/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.param.imex.wizards;

import de.bsvrz.dav.daf.main.config.SystemObjectType;

/**
 * Knoten für die Darstellung eines Typobjekts im Baum für die Darstellung der
 * zu exportierenden Datensätze im Parameter-Export-Assistenten.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 */
class TypeNode extends CheckableNode {

	/** der Knoten unter dem die Parameterdefinitionen (ATG) abgelegt sind. */
	private final CheckableNode parameterNode;

	/**
	 * Konstruktor, erzeugt den Knoten für den übergebenen Systemobjekttyp.
	 *
	 * @param obj
	 *            der Typ
	 */
	public TypeNode(final SystemObjectType obj) {
		super(obj);

		parameterNode = new TypeParametersNode(obj);
		if (parameterNode.getChildren().size() > 0) {
			addChild(parameterNode);
			final CheckableNode objectNode = new TypeObjectTreeNode(obj);
			if (objectNode.getChildren().size() > 0) {
				addChild(objectNode);
			}
		}
	}

	@Override
	public String toString() {
		return getValue().toString();
	}

	/**
	 * liefert den Knoten unter dem die Parameterdefinitionen (ATG) abgelegt sind.
	 *
	 * @return den Knoten oder null;
	 */
	public CheckableNode getParameterNode() {
		return parameterNode;
	}
}
