/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.imex.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

abstract class CheckableNode {
    private final Object value;
    private CheckableNode parent;
    private final Set<CheckableNode> children = new HashSet<CheckableNode>();
    private boolean checkState;

    protected CheckableNode(Object value) {
        this.value = value;
    }

    protected void addChild(CheckableNode child) {
        if (child != null && this.children.add(child)) {
            child.setParent(this);
        }
    }

    public void markRekursiv(boolean state) {
        this.checkState = state;
        for (CheckableNode child : this.children) {
            child.markRekursiv(state);
        }
        CheckableNode checkParent = this.getParent();
        while (checkParent != null) {
            checkParent.checkState = state;
            checkParent = checkParent.getParent();
        }
    }

    public Collection<CheckableNode> getCheckedNodesOfType(Class<? extends CheckableNode> clazz) {
        ArrayList<CheckableNode> result = new ArrayList<CheckableNode>();
        if ((clazz == null || this.getClass().equals(clazz)) && this.isChecked()) {
            result.add(this);
        }
        for (CheckableNode child : this.children) {
            result.addAll(child.getCheckedNodesOfType(clazz));
        }
        return result;
    }

    protected final Set<CheckableNode> getChildren() {
        return this.children;
    }

    public final CheckableNode getParent() {
        return this.parent;
    }

    protected Object getValue() {
        return this.value;
    }

    public boolean isChecked() {
        boolean result = false;
        for (CheckableNode child : this.children) {
            if (!child.isChecked()) continue;
            result = true;
            break;
        }
        return result;
    }

    protected final boolean isCheckState() {
        return this.checkState;
    }

    public boolean isGrayed() {
        boolean result = false;
        boolean oneChecked = false;
        for (CheckableNode child : this.children) {
            if (child.isGrayed()) {
                result = true;
                break;
            }
            if (child.isChecked()) {
                oneChecked = true;
                result = false;
                continue;
            }
            if (!oneChecked) continue;
            result = true;
            break;
        }
        return result;
    }

    protected void removeChild(CheckableNode child) {
        if (this.children.remove(child)) {
            child.setParent(null);
        }
    }

    private void setParent(CheckableNode parent) {
        this.parent = parent;
    }

    public String toString() {
        String result = null;
        result = this.value == null ? "Keine Daten" : this.value.toString();
        return result;
    }

    protected void initSelectionFor(Object object) {
        if (object.equals(this.getValue())) {
            this.markRekursiv(true);
        } else {
            for (CheckableNode child : this.children) {
                child.initSelectionFor(object);
            }
        }
    }

    protected CheckableNode findNode(Object search) {
        CheckableNode result = null;
        if (search.equals(this.getValue())) {
            result = this;
        } else {
            for (CheckableNode child : this.getChildren()) {
                result = child.findNode(search);
                if (result != null) break;
            }
        }
        return result;
    }
}

