/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.imex.wizards;

import de.bsvrz.buv.plugin.param.imex.wizards.CheckableNode;
import de.bsvrz.buv.plugin.param.imex.wizards.DavNode;
import de.bsvrz.buv.plugin.param.imex.wizards.ParameterExportNodeContentProvider;
import de.bsvrz.buv.plugin.param.imex.wizards.ParameterSetNode;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public final class ParameterExportSelectionPage
extends WizardPage {
    private CheckboxTreeViewer viewer;
    private DavNode davNode;
    private String destName;

    public ParameterExportSelectionPage() {
        super("Datensatzauswahl", "Parameterdaten exportieren", null);
    }

    public void createControl(Composite parent) {
        this.setMessage("W\u00e4hlen Sie die Typen, Objekte oder Datens\u00e4tze aus, die exportiert werden sollen!");
        Composite panel = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(panel);
        Label label = new Label(panel, 0);
        label.setText("Datensatzauswahl:");
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)label);
        this.viewer = new CheckboxTreeViewer(panel);
        this.viewer.setComparator(new ViewerComparator());
        ParameterExportNodeContentProvider contentProvider = new ParameterExportNodeContentProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.setCheckStateProvider((ICheckStateProvider)contentProvider);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((CheckableNode)event.getElement()).markRekursiv(event.getChecked());
                ((Viewer)event.getCheckable()).refresh();
            }
        });
        this.davNode = new DavNode();
        this.viewer.setInput((Object)this.davNode);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).hint(300, 500).applyTo((Control)this.viewer.getTree());
        label = new Label(panel, 0);
        label.setText("Ziel:");
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)label);
        final Text destNameField = new Text(panel, 2048);
        destNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParameterExportSelectionPage.this.setDestName(destNameField.getText().trim());
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)destNameField);
        Button fileSelBtn = new Button(panel, 8);
        fileSelBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ParameterExportSelectionPage.this.getShell());
                String result = dialog.open();
                if (result != null) {
                    destNameField.setText(result);
                    ParameterExportSelectionPage.this.setDestName(result);
                }
            }
        });
        fileSelBtn.setText("Suchen");
        GridDataFactory.swtDefaults().applyTo((Control)fileSelBtn);
        this.initializeSelection();
        this.viewer.refresh();
        this.setControl((Control)panel);
    }

    public String getDestName() {
        return this.destName;
    }

    public Map<SystemObject, Set<AttributeGroup>> getExportSelection() {
        HashMap<SystemObject, Set<AttributeGroup>> result = new HashMap<SystemObject, Set<AttributeGroup>>();
        for (CheckableNode obj : this.davNode.getCheckedNodesOfType(ParameterSetNode.class)) {
            SystemObject object = ((ParameterSetNode)obj).getSystemObject();
            AttributeGroup atg = ((ParameterSetNode)obj).getValue();
            if (atg == null || object == null) continue;
            HashSet<AttributeGroup> set = (HashSet<AttributeGroup>)result.get(object);
            if (set == null) {
                set = new HashSet<AttributeGroup>();
                result.put(object, set);
            }
            set.add(atg);
        }
        return result;
    }

    private void initializeSelection() {
        ISelection selection;
        if (this.davNode != null && (selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection()) instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                this.davNode.addInitialSelectionFor(object);
                ++n2;
            }
        }
    }

    void setDestName(String destName) {
        this.destName = destName;
    }
}

