/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.imex.wizards;

import de.bsvrz.buv.plugin.param.imex.ParamImExFunktion;
import de.bsvrz.buv.plugin.param.imex.ParameterImex;
import de.bsvrz.buv.plugin.param.imex.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.imex.wizards.ParameterExportSelectionPage;
import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.puk.param.lib.MethodenBibliothek;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterClientException;
import de.bsvrz.puk.param.lib.ParameterInfo;
import de.bsvrz.puk.param.lib.SerializableParameter;
import de.bsvrz.sys.funclib.debug.Debug;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ParameterExportWizard
extends Wizard
implements IExportWizard {
    private final ParameterExportSelectionPage selectionPage = new ParameterExportSelectionPage();

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.selectionPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean performFinish() {
        if (!ParamImExFunktion.EXPORTIEREN.isFreigegeben()) {
            ParameterImex.zeigeFehler("Sie haben keine Berechtigung zum Exportieren von Parametern!");
            return false;
        }
        boolean result = false;
        String destName = this.selectionPage.getDestName();
        if (destName == null) {
            ParameterImex.zeigeFehler("Es wurde keine Zieldatei angegeben, in die die Daten exportiert werden sollen!");
            return false;
        }
        File file = new File(destName);
        if (file.exists() && !MessageDialog.openConfirm((Shell)this.getShell(), (String)"Exportieren", (String)("Soll die bestehende Datei: " + destName + "\u00fcberschrieben werden?"))) {
            return false;
        }
        Rahmenwerk rahmenwerk = RahmenwerkService.getService().getRahmenWerk();
        if (!rahmenwerk.isOnline()) {
            ParameterImex.zeigeFehler("Es besteht keine g\u00fcltige Datenverteilerverbindung!");
            return false;
        }
        ObjectOutputStream stream = null;
        try {
            try {
                stream = new ObjectOutputStream(new FileOutputStream(file));
                for (Map.Entry<SystemObject, Set<AttributeGroup>> entry : this.selectionPage.getExportSelection().entrySet()) {
                    SystemObject object = entry.getKey();
                    for (AttributeGroup atg : entry.getValue()) {
                        try {
                            Parameter[] parameters = object instanceof SystemObjectType ? MethodenBibliothek.getParameterManager((ClientDavInterface)rahmenwerk.getDavVerbindung()).getParameter(true, new ParameterInfo[]{new ParameterInfo(object, (SystemObjectType)object, atg)}) : MethodenBibliothek.getParameterManager((ClientDavInterface)rahmenwerk.getDavVerbindung()).getParameter(true, new ParameterInfo[]{new ParameterInfo(object, atg)});
                            Parameter[] parameterArray = parameters;
                            int n = parameters.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Parameter parameter = parameterArray[n2];
                                stream.writeObject(new SerializableParameter(rahmenwerk.getDavVerbindung(), parameter));
                                ++n2;
                            }
                        }
                        catch (ParameterClientException e) {
                            ParameterImex.zeigeFehler((Exception)((Object)e));
                        }
                    }
                }
                result = true;
                return result;
            }
            catch (FileNotFoundException e) {
                ParameterImex.zeigeFehler(e);
                if (stream == null) return result;
                try {
                    stream.close();
                    return result;
                }
                catch (IOException e2) {
                    Debug.getLogger().finest(e2.getLocalizedMessage(), (Throwable)e2);
                }
                return result;
            }
            catch (IOException e) {
                ParameterImex.zeigeFehler(e);
                if (stream == null) return result;
                try {
                    stream.close();
                    return result;
                }
                catch (IOException e3) {
                    Debug.getLogger().finest(e3.getLocalizedMessage(), (Throwable)e3);
                }
                return result;
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    Debug.getLogger().finest(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }
}

