/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.imex.wizards;

import de.bsvrz.buv.plugin.param.imex.ParameterImex;
import de.bsvrz.puk.param.lib.ParameterInfo;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class ParameterImportResultDialog
extends Dialog {
    private final Map<ParameterInfo, String> errors;

    protected ParameterImportResultDialog(Shell parent, Map<ParameterInfo, String> errors) {
        super(parent);
        this.errors = errors;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "Ausgabe", false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void cancelPressed() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        String fileName = dialog.open();
        if (fileName != null) {
            this.exportErrors(fileName);
        }
    }

    private void exportErrors(String fileName) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (PrintWriter output = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), Charset.defaultCharset()));){
                for (Map.Entry<ParameterInfo, String> error : this.errors.entrySet()) {
                    output.print(error.getKey().getObjekt().toString());
                    output.print(';');
                    output.print(error.getKey().getAtg().toString());
                    output.print(';');
                    output.println(error.getValue());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            ParameterImex.zeigeFehler(e);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Parameter-Import");
        Composite panel = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        GridLayoutFactory.swtDefaults().applyTo(panel);
        Label label = new Label(panel, 0);
        label.setText("Fehler beim Import: ");
        Composite tablePanel = new Composite(panel, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(500, 300).applyTo((Control)tablePanel);
        TableColumnLayout tabLayout = new TableColumnLayout();
        TableViewer viewer = new TableViewer(tablePanel);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column = new TableColumn(table, 0);
        column.setText("Objekt");
        tabLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1));
        column = new TableColumn(table, 0);
        column.setText("Attributgruppe");
        tabLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1));
        column = new TableColumn(table, 0);
        column.setText("Fehler");
        tabLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(2));
        tablePanel.setLayout((Layout)tabLayout);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setComparator(new ViewerComparator());
        viewer.setLabelProvider((IBaseLabelProvider)new ErrorLabelProvider());
        viewer.setInput((Object)this.errors.entrySet().toArray());
        return panel;
    }

    static class ErrorLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ErrorLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element instanceof Map.Entry) {
                Object key = ((Map.Entry)element).getKey();
                Object value = ((Map.Entry)element).getValue();
                if (key instanceof ParameterInfo && value instanceof String) {
                    switch (columnIndex) {
                        case 0: {
                            result = ((ParameterInfo)key).getObjekt().toString();
                            break;
                        }
                        case 1: {
                            result = ((ParameterInfo)key).getAtg().toString();
                            break;
                        }
                        case 2: {
                            result = (String)value;
                            break;
                        }
                    }
                }
            }
            if (result == null) {
                result = "";
            }
            return result;
        }
    }
}

