/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.imex.wizards;

import de.bsvrz.buv.plugin.param.imex.ParamImExFunktion;
import de.bsvrz.buv.plugin.param.imex.ParameterImex;
import de.bsvrz.buv.plugin.param.imex.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.imex.wizards.ParameterImportResultDialog;
import de.bsvrz.buv.plugin.param.imex.wizards.ParameterImportSelectionPage;
import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.puk.param.lib.MethodenBibliothek;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterClientException;
import de.bsvrz.puk.param.lib.ParameterInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ParameterImportWizard
extends Wizard
implements IImportWizard {
    private final transient ParameterImportSelectionPage selectionPage = new ParameterImportSelectionPage();

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.selectionPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        if (!ParamImExFunktion.IMPORTIEREN.isFreigegeben()) {
            ParameterImex.zeigeFehler("Sie haben keine Berechtigung zum Importieren von Parametern!");
            return false;
        }
        final Rahmenwerk rahmenwerk = RahmenwerkService.getService().getRahmenWerk();
        if (!rahmenwerk.isOnline()) {
            ParameterImex.zeigeFehler("Import nicht m\u00f6glich, es besteht keine Datenverteilerverbindung!");
            return false;
        }
        Job job = new Job("Parameter importieren"){
            private final Shell shell;
            {
                super($anonymous0);
                this.shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            }

            protected IStatus run(IProgressMonitor monitor) {
                final HashMap errors = new HashMap();
                for (Map.Entry<Parameter, Set<SystemObject>> source : ParameterImportWizard.this.selectionPage.getParameterSources().entrySet()) {
                    Parameter parameter = source.getKey();
                    Collection objects = source.getValue();
                    if (objects == null || objects.isEmpty()) continue;
                    ArrayList<Parameter> auftraege = new ArrayList<Parameter>();
                    for (SystemObject object : objects) {
                        ParameterInfo info = null;
                        info = object instanceof SystemObjectType ? new ParameterInfo(object, (SystemObjectType)object, parameter.getAtg()) : new ParameterInfo(object, parameter.getAtg());
                        auftraege.add(new Parameter(info, parameter.getDataWithTime()));
                    }
                    try {
                        errors.putAll(MethodenBibliothek.getParameterManager((ClientDavInterface)rahmenwerk.getDavVerbindung()).setParameterChecked(auftraege.toArray(new Parameter[auftraege.size()])));
                    }
                    catch (ParameterClientException e) {
                        ParameterImex.zeigeFehler((Exception)((Object)e));
                    }
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (errors.size() == 0) {
                            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Parameterimport", (String)"Die Parameter wurden erfolgreich importiert!");
                        } else {
                            new ParameterImportResultDialog(shell, errors).open();
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return true;
    }
}

