/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param;

import com.bitctrl.beans.BeanUtils;

import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObjectType;

/**
 * Bean zur Repräsentation eines Eintrags im Feld HierarchieObjekte an der
 * Attributgruppe <code>atg.hierarchieDefinition</code>.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 *
 */
public class HierarchieObjekteEintrag {

	/**
	 * Der konfigurierte ObjektTyp.
	 */
	private final SystemObjectType objektTyp;

	/**
	 * Der konfigurierte NachfolgerTyp. Kann <code>null</code> sein, dann ist dieses
	 * Objekt das (logisch) letzte im Feld.
	 */
	private final SystemObjectType nachfolgerTyp;

	/**
	 * Die Pid der Menge, welche durchsucht werden muss.
	 */
	private final String mengePid;

	/**
	 * Konstruktor übernimmt nur die Member.
	 *
	 * @param objektTyp
	 *            Der konfigurierte ObjektTyp.
	 * @param nachfolgerTyp
	 *            Der konfigurierte NachfolgerTyp. Kann <code>null</code> sein, dann
	 *            ist dieses Objekt das (logisch) letzte im Feld.
	 * @param mengePid
	 *            Die Pid der Menge, welche durchsucht werden muss.
	 */
	public HierarchieObjekteEintrag(final SystemObjectType objektTyp, final SystemObjectType nachfolgerTyp,
			final String mengePid) {
		super();
		this.objektTyp = objektTyp;
		this.nachfolgerTyp = nachfolgerTyp;
		this.mengePid = mengePid;
	}

	/**
	 * Konstruiert ein Objekt aus einem DaV-Datensatz.
	 *
	 * @param item
	 *            der Datensatz vom Typ atl.hierarchieObjekt
	 * @param model
	 *            das zugehörige Datenmodell
	 */
	public HierarchieObjekteEintrag(final Data item, final DataModel model) {
		String s = item.getTextValue("ObjektTyp").getText();
		objektTyp = model.getType(s);
		if (null == objektTyp) {
			throw new IllegalArgumentException("ObjektTyp " + s + " nicht gefunden");
		}
		mengePid = item.getTextValue("Menge").getText();
		s = item.getTextValue("NachfolgerTyp").getText();
		nachfolgerTyp = model.getType(s);
		/* Darf null sein */
	}

	/**
	 * Liefert den konfigurierten ObjektTyp.
	 *
	 * @return der konfigurierte ObjektTyp.
	 */
	public SystemObjectType getObjektTyp() {
		return objektTyp;
	}

	/**
	 * Liefert den konfigurierten NachfolgerTyp. Kann <code>null</code> sein, dann
	 * ist dieses Objekt das (logisch) letzte im Feld.
	 *
	 * @return der konfigurierte NachfolgerTyp.
	 */
	public SystemObjectType getNachfolgerTyp() {
		return nachfolgerTyp;
	}

	/**
	 * Liefert die Pid der Menge, welche durchsucht werden muss.
	 *
	 * @return die Pid
	 */
	public String getMengePid() {
		return mengePid;
	}

	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}

}
