/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param;

import java.beans.PropertyChangeListener;
import java.util.List;

/**
 * Schnittstelle zum Zugriff auf Änderungen der Teilansicht rechts-oben in Abb
 * 5-41.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
public interface IArtDesParametersatzesProvider {

	/**
	 * Symbol, mit welchem gekennzeichnet wird: Aktuellen Zeitpunkt verwenden!
	 */
	long ZEITPUNKT_AKTUELL = -1;

	/**
	 * Name der Property, die die Art des Parametersatzes hält (
	 * {@value #ART_ORIGINAL}, {@value #ART_SIMULATION} oder
	 * {@value #ART_HISTORISCH}).
	 */
	String PROP_ART_DES_PARAMETERSATZES = "artDesParametersatzes";

	/** Name der Property, die den Zeitpunkt enthält (-1 = aktuell). */
	String PROP_ZEITPUNKT = "zeitpunkt";

	/**
	 * Name der Property, die die Simulationsvariante hält (-1, 0, 1, ... 999).
	 */
	String PROP_SELECTEDSIMULATIONSVARIANTE = "selectedSimulationsVariante";

	/**
	 * Radiobutton-Auswahlmöglichkeit 1 = Selektionsmöglichkeit 1: Original.
	 */
	String ART_ORIGINAL = String.valueOf("Original");

	/**
	 * Radiobutton-Auswahlmöglichkeit 2 = Selektionsmöglichkeit 2: Simulation.
	 */
	String ART_SIMULATION = String.valueOf("Simulation");

	/**
	 * Radiobutton-Auswahlmöglichkeit 3 = Selektionsmöglichkeit 3: Historisch.
	 */
	String ART_HISTORISCH = String.valueOf("Historisch");

	/**
	 * Liefert die Art des Parametersatzes. Mögliche Werte sind
	 * {@value #ART_ORIGINAL}, {@value #ART_SIMULATION} oder
	 * {@value #ART_HISTORISCH}
	 *
	 * @return der Text
	 */
	String getArtDesParametersatzes();

	/**
	 * Bestimmt die Art des Parametersatzes. Mögliche Werte sind
	 * {@value #ART_ORIGINAL}, {@value #ART_SIMULATION} oder
	 * {@value #ART_HISTORISCH}
	 *
	 * @param artDesParametersatzes
	 *            die Art
	 */
	void setArtDesParametersatzes(String artDesParametersatzes);

	/**
	 * Liefert den Zeitpunkt oder {@link #ZEITPUNKT_AKTUELL} für "aktuell".
	 *
	 * @return der Zeitpunkt
	 */
	long getZeitpunkt();

	/**
	 * Setzt den Zeitpunkt oder {@link #ZEITPUNKT_AKTUELL} für "aktuell".
	 *
	 * @param zeitpunkt
	 *            der Zeitpunkt
	 */
	void setZeitpunkt(long zeitpunkt);

	/**
	 * Liefert die aktuelle Simulationsvariante.
	 *
	 * @return die aktuelle Simulationsvariante.
	 */
	short getSelectedSimulationsVariante();

	/**
	 * Setzt die simulationsvariante. -1 und 0 geht immer, 1, ... 999 nur, wenn
	 * diese Simulation auch existiert.
	 *
	 * @param simulationsVariante
	 *            die Simulationsvariante
	 */
	void setSelectedSimulationsVariante(short simulationsVariante);

	/**
	 * Erfragt, ob ein Archiv verfügbar ist.
	 *
	 * @return true - es gibt ein Archiv
	 */
	boolean isArchivAvailable();

	/**
	 * Setzt, ob ein Archiv verfügbar ist.
	 *
	 * @param archivAvailable
	 *            true - es gibt ein Archiv
	 */
	void setArchivAvailable(boolean archivAvailable);

	/**
	 * Registriert einen Listener auf eine Property der Klasse.
	 *
	 * @param listener
	 *            der Listener.
	 */
	void addPropertyChangeListener(PropertyChangeListener listener);

	/**
	 * Registriert einen Listener auf eine Property der Klasse.
	 *
	 * @param propertyName
	 *            der Name der zu beobachtenden Propertery.
	 * @param listener
	 *            der Listener.
	 */
	void addPropertyChangeListener(String propertyName, PropertyChangeListener listener);

	/**
	 * Meldet einen Listener auf eine Property der Klasse wieder ab.
	 *
	 * @param listener
	 *            der Listener.
	 */
	void removePropertyChangeListener(PropertyChangeListener listener);

	/**
	 * Meldet einen Listener auf eine Property der Klasse wieder ab.
	 *
	 * @param propertyName
	 *            der Name der Property die nicht mehr beobachtet werden soll.
	 * @param listener
	 *            der Listener.
	 */
	void removePropertyChangeListener(String propertyName, PropertyChangeListener listener);

	/* ****** Die folgenden Funktionen sind nicht mehr Bean ****** */

	/**
	 * Liefert eine sortierte Liste der zur Zeit gültigen Simulationsvarianten. -1
	 * (DataDescription.NO_SIMULATION_VARIANT_SET) und 0 (Echtanlage) sind immer
	 * drin, sowie alle definierten Simulationen.
	 *
	 * @return die Liste
	 */
	List<Short> getValidSimlationsVarianten();

	/**
	 * Bestimmt einen String, der die Simulationsvariante repräsentiert. Für GUIs.
	 *
	 * @param simulationsVariante
	 *            die Simulationsvariante
	 * @return der Text
	 */
	String getSimulationsVarianteString(final short simulationsVariante);
}
