/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param;

import org.eclipse.core.runtime.IAdapterFactory;

import de.bsvrz.buv.plugin.param.internal.RahmenwerkService;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterInfo;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;

/**
 * Adapter für Objekte aus der {@link de.bsvrz.puk.param.lib.MethodenBibliothek}
 * .
 *
 * Folgende Adapter stehen zur Verfügung:
 *
 * <ul>
 * <li>{@link Parameter} -> {@link SystemObject}</li>
 * <li>{@link Parameter} -> {@link SystemObjekt}</li>
 * <li>{@link ParameterInfo} -> {@link SystemObject}</li>
 * <li>{@link ParameterInfo} -> {@link SystemObjekt}</li>
 * </ul>
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
public class ParamAdapterFactory implements IAdapterFactory {

	/**
	 * {@inheritDoc}
	 *
	 * Das suppress warnings ist ok. Die Methodensignatur kann nicht korrigiert
	 * werden, da die Schnittstelle von Eclipse kommt.
	 */
	@Override
	public Object getAdapter(final Object adaptableObject, final Class adapterType) {
		ParameterInfo info = null;
		Object adaptiertesObjekt = null;
		if (adaptableObject instanceof ParameterInfo) {
			info = (ParameterInfo) adaptableObject;
		} else if (adaptableObject instanceof Parameter) {
			info = ((Parameter) adaptableObject).getInfo();
		}

		if (null != info) {
			if (adapterType == SystemObject.class) {
				adaptiertesObjekt = info.getObjekt();
			} else if (adapterType == SystemObjekt.class) {
				final ObjektFactory f = RahmenwerkService.getService().getObjektFactory();
				if (f.isVerbunden()) {
					adaptiertesObjekt = f.getModellobjekt(info.getObjekt());
				}
			}
		}

		return adaptiertesObjekt;
	}

	/**
	 * {@inheritDoc}
	 *
	 * Das suppress warnings ist ok. Die Methodensignatur kann nicht korrigiert
	 * werden, da die Schnittstelle von Eclipse kommt.
	 */
	@Override
	public Class[] getAdapterList() {
		return new Class[] { SystemObject.class, SystemObjekt.class };
	}

}
