/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import de.bsvrz.buv.plugin.param.internal.ParamPlugin;

public enum ParamSharedImage {

	/** Icon 'Fragezeichen' in der Image Registry des Plug-in. */
	QUESTION_MARK("question_mark", "icons/icon_question_mark.gif"),

	/**
	 * Icon 'Rotes Quadrat' (bedeutet: Attributwert nicht gesetzt) in der Image
	 * Registry des Plug-in.
	 */
	ERROR_NULL("error_null", "icons/icon_error_null.gif"),

	/** Icon 'Entfernen' in der Image Registry des Plug-in. */
	REMOVE("remove", "icons/icon_parameter_remove.gif"),

	/** Icon 'Hinzufügen' in der Image Registry des Plug-in. */
	ADD("add", "icons/icon_parameter_add.gif"),

	/** Icon 'Aktualisieren' in der Image Registry des Plug-in. */
	AKTUALISIEREN("aktualisieren", "icons/icon_parameter_aktualisieren.gif"),

	/** Icon 'Überschreiben' in der Image Registry des Plug-in. */
	UEBERSCHREIBEN("ueberschreiben", "icons/icon_parameter_ueberschreiben.gif"),

	/** das Icon 'Kopieren' in der Image Registry des Plug-in. */
	KOPIEREN("kopieren", "icons/icon_parameter_kopieren.gif"),

	/** Icon 'Pfeil nach rechts' in der Image Registry des Plug-in. */
	ARROW_RIGHT("arrow_right", "icons/icon_arrow_right.gif"),

	/** Icon 'Tauschen' in der Image Registry des Plug-in. */
	EXCHANGE("exchange", "icons/icon_exchange.gif"),

	/** Icon 'Parameter' in der Image Registry des Plug-in. */
	PARAMETER("parameter", "icons/icon_parameter.gif"),

	/** Icon 'Bearbeiten' in der Image Registry des Plug-in. */
	BEARBEITEN("bearbeiten", "icons/icon_parameter_bearbeiten.gif"),

	/** Icon 'Entfernen' in der Image Registry des Plug-in. */
	ENTFERNEN("entfernen", "icons/icon_parameter_entfernen.gif");

	private String key;
	private String imagePath;

	private ParamSharedImage(final String key, final String imagePath) {
		this.key = key;
		this.imagePath = imagePath;
	}

	public Image getImage() {
		final Image result = ParamPlugin.getDefault().getImageRegistry().get(key);
		if (result != null) {
			return result;
		}

		final ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin(ParamPlugin.PLUGIN_ID, imagePath);
		if (desc != null) {
			ParamPlugin.getDefault().getImageRegistry().put(key, desc);
			return ParamPlugin.getDefault().getImageRegistry().get(key);
		}
		return null;
	}

	public ImageDescriptor getImageDescriptor() {
		return AbstractUIPlugin.imageDescriptorFromPlugin(ParamPlugin.PLUGIN_ID, imagePath);
	}
}
