/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param;

import de.bsvrz.buv.plugin.param.internal.ParamPlugin;

/**
 * Ausgelagerte Zeichenfolgen (Bezeichner auf Labels, Buttons usw., Hinweistexte
 * etc.).
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
public final class Zeichenketten {

	/**
	 * Bezeichner 'Objektauswahl'.
	 */
	public static final String PLUGIN_PARAM_BEZEICHNER_OBJEKTAUSWAHL = "Objektauswahl";

	/**
	 * Bezeichner 'Betroffene Objekte'.
	 */
	public static final String PLUGIN_PARAM_BEZEICHNER_BETROFFENE_OBJEKTE = "Betroffene Objekte";

	/**
	 * Bezeichner 'Keine Verbindung zum Datenverteiler'.
	 */
	public static final String PLUGIN_PARAM_BEZEICHNER_KEINE_DAVVERBINDUNG = "Keine Verbindung zum Datenverteiler";

	/**
	 * Bezeichner 'Parameter'.
	 */
	public static final String PLUGIN_SIM_BEZEICHNER_SIMULATIONSSTRECKE = "Parameter";

	/**
	 * Bezeichner 'Art des Parametersatzes'.
	 */
	public static final String PLUGIN_PARAM_BEZEICHNER_ART_DES_PARAMETERSATZES = "Art des Parametersatzes";

	/**
	 * Bezeichner 'unbekannt'.
	 */
	public static final String PLUGIN_PARAM_BEZEICHNER_UNBEKANNT = "unbekannt";

	/**
	 * Beschriftung für die Schaltfläche 'Bearbeiten'.
	 */
	public static final String PLUGIN_PARAM_BUTTON_BEARBEITEN = "Bearbeiten";

	/**
	 * Beschriftung für die Schaltfläche 'Überschreiben'.
	 */
	public static final String PLUGIN_PARAM_BUTTON_UEBERSCHREIBEN = "Überschreiben";

	/**
	 * Beschriftung für die Schaltfläche 'Aktualisieren'.
	 */
	public static final String PLUGIN_PARAM_BUTTON_AKTUALISIEREN = "Aktualisieren";

	/**
	 * Beschriftung für die Schaltfläche 'Kopieren'.
	 */
	public static final String PLUGIN_PARAM_BUTTON_KOPIEREN = "Kopieren";

	/**
	 * Beschriftung für die Schaltfläche 'Tauschen'.
	 */
	public static final String PLUGIN_PARAM_BUTTON_TAUSCHEN = "Tauschen";

	/**
	 * Beschriftung für die Schaltfläche 'Löschen'.
	 */
	public static final String PLUGIN_PARAM_BUTTON_LOESCHEN = "Löschen";

	/**
	 * Beschriftung für die Schaltfläche 'Hilfe'.
	 */
	public static final String PLUGIN_PARAM_BUTTON_HILFE = "Hilfe";

	/**
	 * Hinweistext, dass die zu speichernden Parameter nicht bestimmt werden
	 * konnten.
	 */
	public static final String PLUGIN_PARAM_HINWEIS_ZU_SPEICHERNDE_PARAMETER_NICHT_BESTIMMBAR = "Die zu speichernden Parameter konnten nicht bestimmt werden.\nVerwendeter Save Mode: ";

	/**
	 * Hinweistext, die Parametrierung der Parametrierung zu prüfen. Wird
	 * geschrieben, wenn beim Abruf der Sollparameter keine Daten empfangen wurden.
	 */
	public static final String PLUGIN_PARAM_HINWEIS_PARAM_PARAM_PRUEFEN = " enthält keine Daten."
			+ " Überprüfen Sie die Parametrierung der Parametrierung.";

	/**
	 * Muss identisch sein zum Default-Parametersatz an der
	 * <code>atg.simulationsStreckenBeschreibung</code>, Attribut "Name", siehe
	 * kv.kappich/kb.tmVewSimulationGlobal.xml.
	 */
	public static final String PLUGIN_SIM_BEZEICHNER_NEUE_SIMSTRECKE = "Neue Simulationsstrecke";

	/**
	 * Hinweistext: Keine Quelle für Kopieraktion!
	 */
	public static final String PARAM_PLUGIN_HINWEIS_KEINE_QUELLE = "Keine Quelle für Kopieraktion!";

	/**
	 * Erkennungsmerkmal für Platzhalterspalten. Die brauchen wir für leere Felder.
	 */
	public static final String EMPTY_INDICATOR = "Leer";

	/**
	 * Bezeichner 'Vollständiger Attributname: '.
	 */
	public static final String PLUGIN_PARAM_BEZEICHNER_VOLLSTAENDIER_ATTRNAME = "Vollständiger Attributname: ";

	/**
	 * Default-Belegung der Property
	 * {@link #PLUGIN_PARAM_PROPERTY_WARNUNG_BEI_MEHRFACHAUSWAHL}. Der Wert wird in
	 * die lokalen, allgemeinen Einstellungen geschrieben, wenn er dort noch nicht
	 * existiert.
	 */
	public static final String PLUGIN_PARAM_PROPERTY_WARNUNG_BEI_MEHRFACHAUSWAHL_DEFAULT = "ja";

	/**
	 * Schlüssel für die Property 'Warnung bei Mehrfachauswahl' (Siehe auch
	 * #PLUGIN_PARAM_PROPERTY_WARNUNG_BEI_MEHRFACHAUSWAHL_DEFAULT).
	 */
	public static final String PLUGIN_PARAM_PROPERTY_WARNUNG_BEI_MEHRFACHAUSWAHL = ParamPlugin.PLUGIN_ID
			+ ".WarnungBeiMehrfachauswahl";

	/**
	 * Leerer, privater Konstruktor, keine Instanzen erlaubt.
	 */
	private Zeichenketten() {
		// Leer
	}
}
