/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;

/**
 * Abstrakte Superklasse für FormPages, die gemeinsame Funktionalitäten aller
 * Parametereditoren vereinen (STRG+E z.B.).
 *
 * Credits to Christian Hösel for finding out how to do this.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 *
 */
public abstract class AbstractParameterFormPage extends FormPage {

	/**
	 * Der Kontext, in dem die {@link org.eclipse.ui.forms.editor.FormPage}
	 * arbeitet. Wird für den ShortCut <Strg+E> benötigt.
	 */
	private IContextActivation editorContext;

	/**
	 * Die Aktion zum Exportieren des Editores nach CSV, HTML o.ä.
	 */
	private IAction exportAction;

	/**
	 * Konstruktor reicht nur durch.
	 *
	 * @param id
	 *            a unique page identifier
	 * @param title
	 *            a user-friendly page title
	 */
	public AbstractParameterFormPage(final String id, final String title) {
		super(id, title);
	}

	/**
	 * A constructor that creates the page and initializes it with the editor.
	 *
	 * @param editor
	 *            the parent editor
	 * @param id
	 *            the unique identifier
	 * @param title
	 *            the page title
	 */
	public AbstractParameterFormPage(final FormEditor editor, final String id, final String title) {
		super(editor, id, title);
	}

	@Override
	public void setActive(final boolean active) {
		super.setActive(active);
		final IContextService cs = PlatformUI.getWorkbench().getAdapter(IContextService.class);
		if (active) {
			editorContext = cs.activateContext(ParameterEditor.PARAMETER_EDITOR_KONTEXT);
		} else {
			if (editorContext != null) {
				cs.deactivateContext(editorContext);
			}
		}
	}

	/**
	 * Liefert die Aktion zum Exportieren des Editors nach CSV, HTML o.ä.
	 *
	 * @return die Aktion. Kann <code>null</code> sein.
	 */
	public IAction getExportAction() {
		return exportAction;
	}

	/**
	 * Setzt die Aktion zum Exportieren des Editors nach CSV, HTML o.ä.
	 *
	 * @param exportAction
	 *            die Aktion. Kann <code>null</code> sein.
	 */
	public void setExportAction(final IAction exportAction) {
		this.exportAction = exportAction;
	}
}
