/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors;

import com.bitctrl.util.ArrayMemberCombinator;

/**
 * Kombinator für Texte, die mit de.bsvrz.dav.daf.main.DataData#asTextValue()
 * erzeugt wurden.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 *
 */
public class DataValueTextArrayMemberCombinator extends ArrayMemberCombinator<String, Boolean> {

	/**
	 * Stringrepräsentation von Attributwerten, die keinen Wert zugewiesen bekommen
	 * haben (die Default-Implementierung von
	 * de.bsvrz.dav.daf.main.DataData#toString() setzt "<Undefiniert>").
	 */
	public static final String IDENTIFIER_NICHT_DEFINIERT = "<Undefiniert>";

	/**
	 * Konstruktor reicht nur durch.
	 *
	 * @param inputs
	 *            Feld mit Eingabedaten. Muss mindestens ein Element enthalten
	 * @param alwaysFirst
	 *            Wenn true, wird immer mit dem ersten Element aus inputs
	 *            gearbeitet, ansonsten konsekutive Elemente.
	 */
	public DataValueTextArrayMemberCombinator(final String[] inputs, final boolean alwaysFirst) {
		super(inputs, alwaysFirst);
	}

	@Override
	protected Boolean combine(final String i1, final String i2) {
		boolean result = true;
		if (null != i1 && null != i2) {
			if (!IDENTIFIER_NICHT_DEFINIERT.equals(i1) && !IDENTIFIER_NICHT_DEFINIERT.equals(i2)) {
				result = i1.equals(i2);
			}
		}
		return result;
	}

}
