/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Zusammenfassung einiger Informationen zu einem Parametereditor.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
public final class ParameterEditorInfo {

	/**
	 * der Name des Editors.
	 */
	private final String name;

	/**
	 * den Hersteller des Editors.
	 */
	private final String manufacturer;

	/**
	 * die Version des Editors.
	 */
	private final String version;

	/**
	 * das Release-Datum des Editors.
	 */
	private final Date releaseDate;

	/**
	 * Konstruktor initialisiert das Objekt.
	 *
	 * @param name
	 *            der Name des Editors. Kann <code>null</code> sein, in dem Fall
	 *            wird ein Default-String zugewiesen.
	 * @param manufacturer
	 *            den Hersteller des Editors. Kann <code>null</code> sein, in dem
	 *            Fall wird ein Default-String zugewiesen.
	 * @param version
	 *            die Version des Editors. Kann <code>null</code> sein, in dem Fall
	 *            wird ein Default-String zugewiesen.
	 * @param releaseDate
	 *            das Release-Datum des Editors. Kann <code>null</code> sein, in dem
	 *            Fall wird das heutige Datum zugewiesen.
	 */
	public ParameterEditorInfo(final String name, final String manufacturer, final String version,
			final Date releaseDate) {
		if (null == name || name.length() <= 0) {
			this.name = "Unbekannter Editor";
		} else {
			this.name = name;
		}
		if (null == manufacturer || manufacturer.length() <= 0) {
			this.manufacturer = "unbekannt";
		} else {
			this.manufacturer = manufacturer;
		}
		if (null == version || version.length() <= 0) {
			this.version = "unbekannt";
		} else {
			this.version = version;
		}
		if (null == releaseDate) {
			this.releaseDate = new Date();
		} else {
			this.releaseDate = releaseDate;
		}
	}

	/**
	 * Liefert den Namen des Editors.
	 *
	 * @return der Name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Liefert den Hersteller des Editors.
	 *
	 * @return der Hersteller
	 */
	public String getManufacturer() {
		return manufacturer;
	}

	/**
	 * Liefert die Version des Editors.
	 *
	 * @return die Version
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * Liefert das Release-Datum des Editors.
	 *
	 * @return das Release-Datum
	 */
	public Date getReleaseDate() {
		return releaseDate;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
		return getName() + "\n\nHersteller: " + getManufacturer() + "\nVersion " + getVersion() + " (vom "
				+ dateFormat.format(getReleaseDate()) + ")";
	}
}
