/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors;

import java.util.Arrays;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

import de.bsvrz.buv.rw.basislib.legende.ICustomLegende;

/**
 * Legendenabschnitt für einen Parametereditor. Er zeigt eine statische
 * Erläuterung der Farben und Fettdruckdarstellung.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 */
public class ParameterEditorLegendenAbschnitt implements ICustomLegende {

	/**
	 * Breite der Zelle mit der Farbe.
	 */
	private static final int COLOR_RECTANGLE_WIDTH = 50;

	/**
	 * Konstruktor initialisiert nur Member.
	 *
	 * @param input
	 *            Editor-Inputobjekt
	 */
	public ParameterEditorLegendenAbschnitt(final ParameterEditorInput input) {
		// leer.
	}

	@Override
	public void createControl(final Composite flaeche) {
		Label l;
		GridData gd;
		Color color;
		flaeche.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		flaeche.setLayout(new GridLayout(1, false));
		final Composite farbenComposite = new Composite(flaeche, SWT.NONE);
		farbenComposite.setLayout(new GridLayout(2, false));
		// Kopf
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("Vorgabe-Parameter, die sich zu");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		gd.horizontalSpan = 2;
		l.setLayoutData(gd);
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("... unterscheiden, sind");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		l.setLayoutData(gd);
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("so eingefärbt:");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		l.setLayoutData(gd);

		// Inhalt
		// Default
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("Defaultparametern");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		l.setLayoutData(gd);
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		gd.widthHint = ParameterEditorLegendenAbschnitt.COLOR_RECTANGLE_WIDTH;
		l.setLayoutData(gd);
		color = ParameterEditorInput.getVorgabeColor(Arrays.asList(true, true, false));
		l.setBackground(color);

		// Soll
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("Sollparametern");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		l.setLayoutData(gd);
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		gd.widthHint = ParameterEditorLegendenAbschnitt.COLOR_RECTANGLE_WIDTH;
		l.setLayoutData(gd);
		color = ParameterEditorInput.getVorgabeColor(Arrays.asList(false, true, true));
		l.setBackground(color);

		// Ist
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("Istparametern");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		l.setLayoutData(gd);
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		gd.widthHint = ParameterEditorLegendenAbschnitt.COLOR_RECTANGLE_WIDTH;
		l.setLayoutData(gd);
		color = ParameterEditorInput.getVorgabeColor(Arrays.asList(true, false, true));
		l.setBackground(color);

		// Default- und Soll
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("Default- und Sollparametern");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		l.setLayoutData(gd);
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		gd.widthHint = ParameterEditorLegendenAbschnitt.COLOR_RECTANGLE_WIDTH;
		l.setLayoutData(gd);
		color = ParameterEditorInput.getVorgabeColor(Arrays.asList(false, true, false));
		l.setBackground(color);

		// Default- und Ist
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("Default- und Istparametern");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		l.setLayoutData(gd);
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		gd.widthHint = ParameterEditorLegendenAbschnitt.COLOR_RECTANGLE_WIDTH;
		l.setLayoutData(gd);
		color = ParameterEditorInput.getVorgabeColor(Arrays.asList(true, false, false));
		l.setBackground(color);

		// Soll- und Ist
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("Soll- und Istparametern");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		l.setLayoutData(gd);
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		gd.widthHint = ParameterEditorLegendenAbschnitt.COLOR_RECTANGLE_WIDTH;
		l.setLayoutData(gd);
		color = ParameterEditorInput.getVorgabeColor(Arrays.asList(false, false, true));
		l.setBackground(color);

		// allen anderen
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("allen anderen");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		l.setLayoutData(gd);
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		gd.widthHint = ParameterEditorLegendenAbschnitt.COLOR_RECTANGLE_WIDTH;
		l.setLayoutData(gd);
		color = ParameterEditorInput.getVorgabeColor(Arrays.asList(false, false, false));
		l.setBackground(color);
	}

	@Override
	public String getTitel() {
		return "Parameter-Editor";
	}

	@Override
	public Control getControl() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Corner getDefaultCorner() {
		// TODO Auto-generated method stub
		return null;
	}

}
