/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.IFormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

/**
 * Spezialtoolkit, welches bei createScrolledForm ein solches OHNE SCROLLBARS
 * liefern kann, in Abhängigkeit von einem Parameter!
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 *
 */
public class ParameterFormToolkit extends FormToolkit {

	/**
	 * die zu verwendenden Stylebits für das ScrolledForm. Werden mit orientation
	 * zusammengeODERt.
	 */
	private final int formStyleBits;

	/**
	 * Creates a toolkit that is self-sufficient (will manage its own colors).
	 * <p>
	 * Clients that call this method must call {@link #dispose()} when they are
	 * finished using the toolkit.
	 *
	 * @param display
	 *            das zu verwendende Display
	 * @param formStyleBits
	 *            die zu verwendenden Stylebits für das ScrolledForm. Werden mit
	 *            orientation zusammengeODERt.
	 *
	 */
	public ParameterFormToolkit(final Display display, final int formStyleBits) {
		super(display);
		this.formStyleBits = formStyleBits;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.eclipse.ui.forms.widgets.FormToolkit#createScrolledForm(org.eclipse
	 * .swt.widgets.Composite)
	 */
	@Override
	public ScrolledForm createScrolledForm(final Composite parent) {
		final ScrolledForm form = new ScrolledForm(parent, getOrientation() | formStyleBits);
		form.setExpandHorizontal(true);
		form.setExpandVertical(true);
		form.setBackground(getColors().getBackground());
		form.setForeground(getColors().getColor(IFormColors.TITLE));
		form.setFont(JFaceResources.getHeaderFont());
		return form;
	}

}
