/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors;

/**
 * Aufzählung der möglichen Ergebnisse eines Speciherversuchs mit
 * {@link ParameterSaver#saveParameters(de.bsvrz.puk.param.lib.Parameter[], String)}
 * .
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
public enum ParameterSaveResultEnum {

	/**
	 * Parameter wurden erfolgreich geschrieben. Der über
	 * {@link ParameterSaver#getLastError()} ausgelesene Text ist ungültig.
	 */
	PARAMETER_SAVE_SUCCESS("Speichern erfolgreich"),

	/**
	 * Mindestens ein Parameter wurde nicht erfolgreich geschrieben. In diesem Fall
	 * ist der über {@link ParameterSaver#getLastError()} ausgelesene Text gültig.
	 */
	PARAMETER_SAVE_FAILURE("Speichern fehlgeschlagen"),

	/**
	 * Der Benutzer hat den Vorgang abgebrochen, es wurden keine Parameter
	 * geschrieben. Der über {@link ParameterSaver#getLastError()} ausgelesene Text
	 * ist ungültig.
	 */
	PARAMETER_SAVE_CANCEL("Speichern abgebrochen");

	/**
	 * Die Textnachricht, die dem Enum zugeordnet werden soll.
	 */
	private final String msg;

	/**
	 * Privater Konstruktor, keine neuen Instanzen möglich.
	 *
	 * @param msg
	 *            Die Textnachricht, die dem Enum zugeordnet werden soll
	 */
	private ParameterSaveResultEnum(final String msg) {
		this.msg = msg;
	}

	/**
	 * Liefert die Textnachricht, die dem Enum zugeordnet werden soll.
	 *
	 * @return die Nachricht.
	 */
	public String getMsg() {
		return msg;
	}

}
