/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors.attribut;

import org.eclipse.jface.dialogs.IInputValidator;

/**
 * Validator für Stringattribute aus dem DaV.
 *
 * @author @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 *
 */
public class StringLengthInputValidator implements IInputValidator {

	/**
	 * Maximal erlaubte Länge des String.
	 */
	private final int maxLength;

	/**
	 * Konstruktor prüft Werte.
	 *
	 * @param maxLength
	 *            Maximal erlaubte Länge
	 */
	public StringLengthInputValidator(final int maxLength) {
		this.maxLength = maxLength;
	}

	@Override
	public String isValid(final String newText) {
		String errorMessage = null;
		if (null == newText) {
			errorMessage = "Es muss ein Text übergeben werden";
		} else if (newText.length() > maxLength) {
			errorMessage = "Der Text ist zu lang";
		}
		return errorMessage;
	}

}
