/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors.helper;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.viewers.TreeViewer;

import de.bsvrz.dav.daf.main.Data;

/**
 * to save (push) and rebuild (pop) the tree state after the refreshing.
 *
 * @author BitCtrl Systems GmbH, Thomas Thierfelder
 *
 */
public class ExpandState {

	/** das Composite, für das wir zuständig sind. */
	private final ParaEditComposite pec;

	/**
	 * der TreeViewer, dessen Status abgeepciert werden soll.
	 */
	private final TreeViewer stateTreeViewer;

	/**
	 * der momentane Explorations-Status.
	 */
	private List<Data> expObj;

	/**
	 * die Liste der konvertierten Objekte.
	 */
	private List<MyTreeObject> conv;

	/**
	 * Standardkonstruktor.
	 *
	 * @param ttv
	 *            der TreeViewer, dessen Status abgeepciert werden soll
	 * @param pec
	 *            das Composite, für das wir zuständig sind.
	 */
	public ExpandState(final TreeViewer ttv, final ParaEditComposite pec) {
		this.stateTreeViewer = ttv;
		this.pec = pec;
	}

	/**
	 * Aktuellen Zustand abspeichern.
	 */
	public void push() {
		expObj = new ArrayList<>();
		Data dummy = null;
		for (int i = 0; i < stateTreeViewer.getExpandedElements().length; i++) {
			final MyTreeObject myTreeObject = (MyTreeObject) stateTreeViewer.getExpandedElements()[i];
			dummy = (Data) myTreeObject.getData();
			expObj.add(dummy);
		}
	}

	/**
	 * Zuletzt abgespeicherten Zustand wiederherstellen.
	 */
	public void pop() {
		conv = new ArrayList<>();

		for (final Data data : expObj) {
			inOrderSearch(pec.getDataObject(), data);
		}
		stateTreeViewer.setExpandedElements(conv.toArray());
	}

	/**
	 * Macht eine inorder Suche über den Baum root und extrahiert alle als
	 * exploriert gespeicherten Elemente in die Liste <i>conv</i>.
	 *
	 * @param root
	 *            - der Baum
	 * @param data
	 *            - das als exploriert gespeicherte Element
	 * @return das Ergebnis
	 */
	private boolean inOrderSearch(final MyTreeObject root, final Data data) {

		if (root.getData() != null) {
			if (((root.getData()).toString()).equals(data.toString())) {
				conv.add(root);
				return true;
			}
		}
		if (root.hasChildren()) {
			for (final MyTreeObject treeObj : root.getChildren()) {
				if (inOrderSearch(treeObj, data)) {
					return true;
				}
			}
		}
		return false;
	}
}
