/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors.helper;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.buv.plugin.param.editors.attribut.MultiLineInputDialog;

/**
 * Doppelklick-Adapter für die Headline im ParaEditComposite, in der wir
 * neuerdings die Urlasserinformationen anzeigen. In verkürzter Form allerdings,
 * und über Doppelklick öffnen wir hier einen Dialog, in dem der vollständige
 * Text dargestellt wird und herauskopiert werden kann.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 *
 */
public class HeadLineMouseAdapter extends MouseAdapter {

	/**
	 * Das Composite, dessen Headline wir aktualisieren sollen.
	 */
	private final ParaEditComposite pec;

	/**
	 * Konstruktor übernimmt Composite und prüft auf Not-NULL.
	 *
	 * @param pec
	 *            Das Composite, dessen Headline wir aktualisieren sollen.
	 */
	public HeadLineMouseAdapter(final ParaEditComposite pec) {
		this.pec = pec;
		Assert.isNotNull(pec);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.eclipse.swt.events.MouseAdapter#mouseDoubleClick(org.eclipse.swt.
	 * events.MouseEvent)
	 */
	@Override
	public void mouseDoubleClick(final MouseEvent e) {
		final MultiLineInputDialog dialog = new MultiLineInputDialog(
				PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Urlasserinformationen",
				"Im Textfeld sehen Sie die vollständigen Urlasserinformationen\nfür das Objekt '"
						+ pec.getVorgabeParameterInfo().getObjekt().toString() + "'\nan der Attributgruppe '"
						+ pec.getVorgabeParameterInfo().getAtg().toString() + "':",
				pec.getUrlasserInfosAsSingleString(true), null);
		dialog.open();
	}

}
