/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors.helper;

import de.bsvrz.buv.plugin.param.editors.ParameterEditorInput;
import de.bsvrz.dav.daf.main.config.AttributeType;

/**
 * Schnittstelle, um einem {@link ParaEditComposite} Zugriff auf das
 * übergeordnete Objekt zu verschaffen.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
public interface IParaEditCompositeContainer {

	/**
	 * Mit dieser Methode kann ein {@link ParaEditComposite} seinem enthaltenden
	 * Objekt mitteilen, dass ein Attribut verändert wurde und deshalb Abspeichern
	 * notwendig ist.
	 *
	 * @param pec
	 *            das Composite
	 * @param status
	 *            der neue Status
	 */
	void dirtyStateChanged(ParaEditComposite pec, boolean status);

	/**
	 * Benachrichtigung über Änderungen in einem Editor.
	 *
	 * @param pec
	 *            der Editor, in dem die Änderung stattfand
	 * @param myTreeObject
	 *            das geänderte Objekt
	 * @param oldValue
	 *            alter Wert
	 * @param newValue
	 *            neuer Wert
	 * @param attributeType
	 *            Typ des Werts. Über diesen kann man entscheiden, wie oldValue und
	 *            newValue zu casten sind: attributeType Typ von oldVaue und
	 *            newValue
	 *            {@link de.bsvrz.dav.daf.main.config.ReferenceAttributeType} ->
	 *            {@link de.bsvrz.dav.daf.main.config.SystemObject}
	 *            {@link de.bsvrz.dav.daf.main.config.IntegerAttributeType}
	 *            (Zahlenwert) -> long
	 *            {@link de.bsvrz.dav.daf.main.config.DoubleAttributeType} -> double
	 *            {@link de.bsvrz.dav.daf.main.config.StringAttributeType} -> String
	 *            {@link de.bsvrz.dav.daf.main.config.TimeAttributeType} -> long
	 *            {@link de.bsvrz.dav.daf.main.config.IntegerAttributeType}
	 *            (Zustand) ->
	 *            {@link de.bsvrz.dav.daf.main.config.IntegerValueState}
	 *
	 */
	void valueModified(ParaEditComposite pec, MyTreeObject myTreeObject, Object oldValue, Object newValue,
			AttributeType attributeType);

	/**
	 * Liefert das Input-Objekt für den Editor, in dem sich der Container befindet.
	 *
	 * @return das Input-Objekt
	 */
	ParameterEditorInput getParameterEditorInput();
}
