/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors.helper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.Attribute;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.puk.param.lib.Parameter;

/**
 * Übersetzt die DAF-Data-Objekte in MyTreeObjects.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 *
 */
public class MyDataObject {

	/**
	 * die Wurzel des neuen <b>MyTreeObject</b>-Objektes.
	 */
	private MyTreeObject root;

	/**
	 * Alle MyTreeObjects als flache Liste.
	 */
	private final List<MyTreeObject> flatList = new ArrayList<>();

	/**
	 * Die Ebene, auf dem sich das MyTreeObject am korespondierenden Index in
	 * flatList befindet.
	 */
	private final List<Integer> ebeneList = new ArrayList<>();

	/**
	 * Standardkonstruktor.
	 */
	public MyDataObject() {
		super();
	}

	/**
	 * Konstruktor: Wandelt ein Data-Objekt in ein MyTreeObjekt um MyTreeObjekt kann
	 * dann besser vom graphischen Editor verwaltet werden.
	 *
	 * @param parameter
	 *            der zu editierende Parameter
	 */
	public MyDataObject(final Parameter parameter) {
		final AttributeGroup attGroup = parameter.getAtg();
		final Data data = parameter.getData();
		Data setData = null;
		Iterator<Data> dataIt = null;

		root = new MyTreeObject(); // empty root object

		if (data != null) {
			dataIt = data.iterator();
		}
		for (final Attribute att : attGroup.getAttributes()) {
			if ((data != null) && (dataIt != null)) {
				if (dataIt.hasNext()) {
					setData = dataIt.next();
				} else {
					setData = null;
				}
			} else {
				setData = null;
			}
			if (!"atl.urlasser".equals(att.getAttributeType().getPid())) {
				addElement(att, setData, root, 0);
			}
		}
	}

	/**
	 * Fügt dem Objekt <i>rootObj</i> eine Menge von Kindern hinzu.
	 *
	 * @param att
	 *            - das Attribut
	 * @param data
	 *            - das Datenelement
	 * @param rootObj
	 *            - hier sollen die Kinder angehängt werden
	 * @param ebene
	 *            Die Ebene im Baum, auf der sich dieses Element befindet.
	 */
	public void addElement(final Attribute att, final Data data, final MyTreeObject rootObj, final int ebene) {
		MyTreeObject newChild = null;
		Iterator<Data> it = null;
		// Data da = null;

		if (data == null) {
			newChild = new MyTreeObject(att, new Object());
			flatList.add(newChild);
			ebeneList.add(ebene);
		} else {
			newChild = new MyTreeObject(att, data);
			flatList.add(newChild);
			ebeneList.add(ebene);
			if (data.isArray() || data.isList()) {
				it = data.iterator();
				while (it.hasNext()) {
					addElement(att, it.next(), newChild, ebene + 1);
				}
			}
		}
		rootObj.add(newChild);
	}

	/**
	 * Erfragt den Inhalt dieses Objektes.
	 *
	 * @return den Inhalt, also das <b>MyTreeObjekt</b>-Objekt
	 */
	public Object getContent() {
		return this.root;
	}

	/**
	 * Liefert alle MyTreeObjects als flache Liste.
	 *
	 * @return die flache Liste
	 */
	public List<MyTreeObject> getFlatList() {
		return flatList;
	}

	/**
	 * Liefert eine Liste von Zahlen, welche genauso lang ist wie die flache Liste
	 * der MyTreeObjects. Der Wert am Index n gibt an, auf welcher Ebene des Baumes
	 * das MyTreeObject in flatList am Index n zu suchen ist.
	 *
	 * @return die Liste
	 */
	public List<Integer> getEbeneList() {
		return ebeneList;
	}
}
