/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors.helper;

/**
 * Konstanten für das {@link ParaEditComposite}.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 *
 */
public final class ParaEditCompositeConstants {

	/**
	 * leer.
	 */
	public static final String EMPTY = "leer"; //$NON-NLS-1$
	/**
	 * Achtung.
	 */
	static final int ALERT = 0;
	/**
	 * Nachricht.
	 */
	public static final int MESSAGE = 1;
	/**
	 * drüber (z.B. Einfügen).
	 */
	public static final int ABOVE = 0;
	/**
	 * darunter (z.B. Einfügen).
	 */
	public static final int BELOW = 1;
	/**
	 * eins am Ende (z.B. Einfügen).
	 */
	public static final int ONE_LAST = 2;
	/**
	 * eins am Anfang (z.B. Einfügen).
	 */
	public static final int ONE_FIRST = 4;
	/**
	 * mehrere am Ende (z.B. Einfügen).
	 */
	public static final int MORE_LAST = 8;
	/**
	 * mehrere am Anfang (z.B. Einfügen).
	 */
	public static final int MORE_FIRST = 16;
	/**
	 * Maximal-Höhe des Composite.
	 */
	public static final int MAX_HEIGHT = 400;
	/**
	 * Maximal-Höhe des Composite.
	 */
	public static final int MIN_HEIGHT = 80;

	/**
	 * Leerer, privater Konstruktor - keine Instanzen erlaubt.
	 */
	private ParaEditCompositeConstants() {
		// Leerer, privater Konstruktor - keine Instanzen erlaubt.
	}
}
