/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;

import com.bitctrl.lib.eclipse.wizards.ComposedWizardDialog;

import de.bsvrz.buv.plugin.param.editors.attribut.MultiLineInputDialog;
import de.bsvrz.buv.plugin.param.editors.attribut.StringLengthInputValidator;
import de.bsvrz.buv.plugin.param.internal.RahmenwerkService;
import de.bsvrz.buv.rw.bitctrl.eclipse.MultipleSelection;
import de.bsvrz.buv.rw.bitctrl.eclipse.SystemObjectAuswahlType;
import de.bsvrz.buv.rw.bitctrl.eclipse.wizards.DatumZeitDialog;
import de.bsvrz.buv.rw.bitctrl.eclipse.wizards.SystemObjectAuswahlWizardPage;
import de.bsvrz.buv.rw.bitctrl.eclipse.wizards.ZeitAuswahlDialog;
import de.bsvrz.buv.rw.bitctrl.eclipse.wizards.ZeitDauerDialog;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.ReferenceAttributeType;
import de.bsvrz.dav.daf.main.config.StringAttributeType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.dav.daf.main.config.TimeAttributeType;

/**
 * Doubleclick-Listener für die Viewer des {@link ParaEditComposite}.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 */
public class ParaEditCompositeDoubleClickListener implements IDoubleClickListener {

	/** das Composite, für das wir zuständig sind. */
	private final ParaEditComposite pec;

	/**
	 * Konstruktopr merkt sich nur Member.
	 *
	 * @param pec
	 *            das Composite, für das wir zuständig sind.
	 */
	public ParaEditCompositeDoubleClickListener(final ParaEditComposite pec) {
		this.pec = pec;
	}

	@Override
	public void doubleClick(final DoubleClickEvent event) {
		if (!event.getSelection().isEmpty() && (event.getSelection() instanceof IStructuredSelection)
				&& !pec.isReadOnly()) {
			final MyTreeObject myTreeObject = (MyTreeObject) ((IStructuredSelection) event.getSelection())
					.getFirstElement();
			if ((myTreeObject.getData() instanceof Data) && ((Data) myTreeObject.getData()).isPlain()) {
				final Data initialData = (Data) myTreeObject.getData();
				if (initialData.getAttributeType() instanceof TimeAttributeType) {
					final long oldValue = initialData.asTimeValue().getMillis();
					long newValue = oldValue;
					final TimeAttributeType attrType = (TimeAttributeType) initialData.getAttributeType();
					ZeitAuswahlDialog azad;
					if (attrType.isRelative()) {
						azad = new ZeitDauerDialog(event.getViewer().getControl().getShell(), initialData);
					} else {
						azad = new DatumZeitDialog(event.getViewer().getControl().getShell(), initialData);
					}
					if (Window.OK == azad.open()) {
						newValue = azad.getSelectedValue();
					}
					if (newValue != oldValue) {
						initialData.asTimeValue().setMillis(newValue);
						if (pec.getContainer() != null) {
							pec.getContainer().valueModified(pec, myTreeObject, oldValue, newValue,
									initialData.getAttributeType());
						}
						pec.refreshPreservingExpandState(null);
					}
				} else if (initialData.getAttributeType() instanceof ReferenceAttributeType) {
					final SystemObject oldValue = initialData.asReferenceValue().getSystemObject();
					final boolean neu = null == oldValue;
					final ReferenceAttributeType referenceAttrType = (ReferenceAttributeType) initialData
							.getAttributeType();
					SystemObjectType referencedType = referenceAttrType.getReferencedObjectType();
					String systemObjektPid;
					final SystemObjectAuswahlType auswahlType;
					if (null == referencedType) {
						final ClientDavInterface davIf = RahmenwerkService.getService().getObjektFactory().getDav();
						referencedType = davIf.getDataModel().getType("typ.typ");
						auswahlType = SystemObjectAuswahlType.TypesOrInstances;
					} else {
						final List<SystemObject> elements = referencedType.getElements();
						if ((null == elements) || elements.isEmpty()) {
							auswahlType = SystemObjectAuswahlType.TypesOrInstances;
						} else {
							int numInstances = 0;
							int numTypes = 0;
							for (final SystemObject o : elements) {
								if (o instanceof SystemObjectType) {
									++numTypes;
								} else {
									++numInstances;
								}
							}
							if (numTypes == 0) {
								auswahlType = SystemObjectAuswahlType.OnlyInstances;
							} else if (numInstances == 0) {
								auswahlType = SystemObjectAuswahlType.OnlyTypes;
							} else {
								auswahlType = SystemObjectAuswahlType.TypesOrInstances;
							}
						}
					}
					systemObjektPid = referencedType.getPid();
					final String descLongAnfang = "Wählen Sie das gewünschte Objekt ";
					final String descLongEnde = " aus.";
					final String aktionString = neu ? " zuweisen" : " modifizieren";
					final SystemObjectAuswahlWizardPage auswahlPage = new SystemObjectAuswahlWizardPage(
							referencedType.toString() + aktionString, MultipleSelection.Single, auswahlType,
							neu ? new ArrayList<SystemObject>() : Arrays.asList(oldValue), systemObjektPid);
					auswahlPage.setDescription(descLongAnfang + referencedType.toString() + descLongEnde);
					final ComposedWizardDialog wizardDialog = new ComposedWizardDialog(
							referencedType.toString() + aktionString, auswahlPage);
					if (Window.OK == wizardDialog.open()) {
						if (!auswahlPage.getAuswahl().isEmpty()) {
							final SystemObject newValue = auswahlPage.getAuswahl().get(0);
							if (null == newValue) {
								pec.doAdvice("Fehler: Referenz-Object konnte nicht identifiziert werden.", //$NON-NLS-1$
										ParaEditCompositeConstants.ALERT);
							} else if (!newValue.equals(oldValue)) {
								initialData.asReferenceValue().setSystemObject(newValue);
								if (pec.getContainer() != null) {
									pec.getContainer().valueModified(pec, myTreeObject, oldValue, newValue,
											referenceAttrType);
								}
								pec.refreshPreservingExpandState(null);
							}
						}
					}
				} else if (initialData.getAttributeType() instanceof StringAttributeType) {
					final StringAttributeType strAttr = (StringAttributeType) initialData.getAttributeType();
					final String oldValue = initialData.asTextValue().getText();
					final InputDialog id = new MultiLineInputDialog(
							null, "Text bearbeiten", "Bitte bearbeiten Sie den Text. Erlaubt sind maximal "
									+ strAttr.getMaxLength() + " Zeichen.",
							oldValue, new StringLengthInputValidator(strAttr.getMaxLength()));
					if (Window.OK == id.open()) {
						final String newValue = id.getValue();
						if ((null == oldValue) || !oldValue.equals(newValue)) {
							initialData.asTextValue().setText(newValue);
							if (pec.getContainer() != null) {
								pec.getContainer().valueModified(pec, myTreeObject, oldValue, newValue, strAttr);
							}
							pec.refreshPreservingExpandState(null);
						}
					}
				}
			}
		}
	}
}
