/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors.helper;

import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Tree;

/**
 * a comboboxcelleditor which is not editable by writing to it by keyboard.
 *
 * @author BitCtrl Systems GmbH, Thomas Thierfelder
 *
 *
 */
public class PureComboBoxSelector extends ComboBoxCellEditor {

	/**
	 * Standardkonstruktor.
	 *
	 * @param table
	 *            die Tabelle
	 */
	public PureComboBoxSelector(final Tree table) {
		super(table, new String[] { "Fehler" }); //$NON-NLS-1$
	}

	/**
	 * Wertet Tastatureingaben aus.
	 *
	 * @param keyEvent
	 *            das Ereignis
	 * @see org.eclipse.jface.viewers.ComboBoxCellEditor#keyReleaseOccured(org.eclipse.swt.events.KeyEvent)
	 */
	@Override
	protected void keyReleaseOccured(final KeyEvent keyEvent) {
		this.setValue(this.getValue());
	}
}
