/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors.helper;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

/**
 * Abstrakte Oberklasse für bestimmte (über Kontextmenü erreichbare) Aktionen
 * die mit dem Editieren von Parametern zusammenhängen.
 *
 * @author BitCtrl Systems GmbH, Thomas Thierfelder
 *
 */
public abstract class TableSelectionAction extends Action implements ISelectionChangedListener {

	/**
	 * Objekt, auf dass sich die Edit-Aktion bezieht.
	 */
	private Object selectedObject;

	/**
	 * Initialisierung.
	 *
	 * @param item
	 *            - Name der Aktion
	 */
	public TableSelectionAction(final String item) {
		super(item);
	}

	/**
	 * Methode zur externen Veränderung des Objektes.
	 *
	 * @param event
	 *            - der externe Event
	 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
	 */
	@Override
	public void selectionChanged(final SelectionChangedEvent event) {
		this.selectedObject = ((StructuredSelection) (event.getSelection())).getFirstElement();
	}

	/**
	 * Gibt das Objekt zurück, auf dass sich die Edit-Aktion bezieht.
	 *
	 * @return des ausgewählte Objekt
	 */
	public Object getSelectedObject() {
		return this.selectedObject;
	}
}
