/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors.helper;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

/**
 * tree-contentprovider concerning with MyTreeObject.
 *
 * @author BitCtrl Systems GmbH, Thomas Thierfelder
 */
public class TableTreeContentProvider implements ITreeContentProvider {

	/**
	 * Erfragt die Kinder eines Baumes.
	 *
	 * @param arg0
	 *            - die Wurzel
	 * @return die Kinder
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
	 */
	@Override
	public Object[] getChildren(final Object arg0) {
		return ((MyTreeObject) arg0).getChildren().toArray();
	}

	/**
	 * Erfragt den Vater eines Baumelementes.
	 *
	 * @param arg0
	 *            - das Baumelement
	 * @return den Vater
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
	 */
	@Override
	public Object getParent(final Object arg0) {
		return ((MyTreeObject) arg0).getRoot();
	}

	/**
	 * Erfragt, ob eine Baumelement Kinder hat.
	 *
	 * @param arg0
	 *            - das Baumelement
	 * @return Element hat Kinder
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
	 */
	@Override
	public boolean hasChildren(final Object arg0) {
		if (arg0 == null) {
			return false;
		}
		return ((MyTreeObject) arg0).hasChildren();
	}

	/**
	 * Erfragt die Kinder eines Baumelements.
	 *
	 * @param arg0
	 *            - das Baumelement
	 * @return die Elemente
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	@Override
	public Object[] getElements(final Object arg0) {
		return getChildren(arg0);
	}

	/**
	 * nicht implementiert.
	 *
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	@Override
	public void dispose() {
		//
	}

	/**
	 * nicht implementiert.
	 *
	 * @param viewer
	 *            der Viewer
	 * @param oldData
	 *            die alten Daten
	 * @param newData
	 *            die neuen Daten
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer,
	 *      java.lang.Object, java.lang.Object)
	 */
	@Override
	public void inputChanged(final Viewer viewer, final Object oldData, final Object newData) {
		//
	}
}
