/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors.helper;

import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;

/**
 * Verschiedene Verifikations-Listener für die Eingabe unterschiedliche Daten in
 * TextCellEditoren.
 *
 * @author BitCtrl Systems GmbH, Thomas Thierfelder
 *
 */
public class UzVerifyListener implements VerifyListener {

	/**
	 * nur Ziffern-Eingaben werden akzepiert.
	 */
	public static final int INT = 0;

	/**
	 * nur Ziffern-Eingaben und "-" werden akzepiert.
	 */
	public static final int INT_MINUS = 1;

	/**
	 * nur Ziffern-Eingaben "," und "-" werden akzepiert.
	 */
	public static final int DOUBLE_MINUS = 2;

	/**
	 * nur Ziffern-Eingaben und ":" werden akzepiert.
	 */
	public static final int TIME = 4;

	/**
	 * nur Ziffern-Eingaben "-" und "." werden akzepiert.
	 */
	public static final int DOUBLE_MINUS_POINT = 8;

	/**
	 * die Art der Validierung der Eingabe.
	 */
	private final int init;

	/**
	 * Standardkonstruktor.
	 *
	 * @param init
	 *            - die Art der Validierung der Eingabe
	 */
	public UzVerifyListener(final int init) {
		this.init = init;
	}

	/**
	 * Wird aufgerufen, wenn die Eingabe in ein Editorfeld verifiziert werden soll.
	 *
	 * @param e
	 *            - die Eingabe
	 * @see org.eclipse.swt.events.VerifyListener#verifyText(org.eclipse.swt.events.VerifyEvent)
	 */
	@Override
	public void verifyText(final VerifyEvent e) {
		int i;

		switch (init) {
		case INT:
			e.doit = true;
			for (i = 0; i < e.text.length(); i++) {
				if ("0123456789".indexOf(e.text.substring(i, i + 1)) == -1) {
					e.doit = false;
				}
			}
			break;
		case INT_MINUS:
			e.doit = true;
			for (i = 0; i < e.text.length(); i++) {
				if ("-0123456789".indexOf(e.text.substring(i, i + 1)) == -1) {
					e.doit = false;
				}
			}
			break;
		case DOUBLE_MINUS:
			e.doit = true;
			for (i = 0; i < e.text.length(); i++) {
				if ("-,0123456789".indexOf(e.text.substring(i, i + 1)) == -1) {
					e.doit = false;
				}
			}
			break;
		case TIME:
			e.doit = true;
			for (i = 0; i < e.text.length(); i++) {
				if (":0123456789".indexOf(e.text.substring(i, i + 1)) == -1) {
					e.doit = false;
				}
			}
			break;
		case DOUBLE_MINUS_POINT:
			e.doit = true;
			for (i = 0; i < e.text.length(); i++) {
				if ("-.0123456789".indexOf(e.text.substring(i, i + 1)) == -1) {
					e.doit = false;
				}
			}
			break;
		default:
			break;
		}
	}
}
