/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.handler;

import java.util.Map;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.RegistryToggleState;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.part.ViewPart;

import de.bsvrz.buv.plugin.param.provider.BetroffeneObjekteContentProvider;

/**
 * Abstrakter Handler für das Kommando der Ansicht
 * {@link de.bsvrz.buv.plugin.param.views.BetroffeneObjekteView}, mit der die
 * Anzeige der NICHT änderbaren Objekte ein- oder ausgeschaltet wird.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann, Uwe Peuker
 *
 */
public abstract class AbstractBetroffeneObjekteAnzeigeUmschaltHandler extends AbstractHandler
		implements IElementUpdater {

	@Override
	public final Object execute(final ExecutionEvent event) throws ExecutionException {

		final boolean toggleCommandState = HandlerUtil.toggleCommandState(event.getCommand());
		final IWorkbenchPart activePart = HandlerUtil.getActivePart(event);
		if (activePart instanceof ViewPart) {
			final ISelectionProvider selectionProvider = ((ViewPart) activePart).getViewSite().getSelectionProvider();
			if (selectionProvider instanceof ContentViewer) {
				final IContentProvider contentProvider = ((ContentViewer) selectionProvider).getContentProvider();
				if (contentProvider instanceof BetroffeneObjekteContentProvider) {
					callSetter((BetroffeneObjekteContentProvider) contentProvider, !toggleCommandState);

					final ICommandService service = PlatformUI.getWorkbench().getService(ICommandService.class);
					service.refreshElements(event.getCommand().getId(), null);
				}

			}
		}
		return null;
	}

	@Override
	public void updateElement(final UIElement element, final Map parameters) {
		final ICommandService service = PlatformUI.getWorkbench().getService(ICommandService.class);
		final Command command = service.getCommand(getToggleCommand());
		final State state = command.getState(RegistryToggleState.STATE_ID);
		element.setChecked((Boolean) state.getValue());
	}

	protected abstract String getToggleCommand();

	/**
	 * Callout in eine konkrete set-Methode am Contentprovider.
	 *
	 * @param contentProvider
	 *            der Contentprovider, ermittelt über den Viewer am View
	 * @param status
	 *            true oder false zum Toggeln der Aktion
	 */
	protected abstract void callSetter(BetroffeneObjekteContentProvider contentProvider, final boolean status);
}
