/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.handler;

import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

import de.bsvrz.buv.plugin.param.editors.ParameterEditorInput;

/**
 * Abstrakter Handler für Kommandos zum Bearbeiten und Löschen von Parametern.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann, Uwe Peuker
 *
 */
public abstract class AbstractParameterModifizierenHandler extends ParamPluginHandler {

	/**
	 * Wendet den initialen Dirty-State auf die Vorgabe-Seite an. Es klappt deshalb,
	 * weil unmittelbar nach dem Öffnen des Editors die Vorgabeseite automatisch
	 * selektiert ist.
	 *
	 * @param editorInput
	 *            das Input-Objekt
	 * @param editor
	 *            der Editor
	 */
	protected void applyInitialDirtyState(final ParameterEditorInput editorInput, final FormEditor editor) {
		switch (editorInput.getInitialDirtyStateMode()) {
		case ONLY_ON_DIFFERENCES_TO_SOLL:
			editorInput.selectVorgabeParameterDifferringToSoll();
			if (!editorInput.getSelectedParameters().isEmpty()) {
				doSetInitialDirty(editorInput, editor);
			}
			break;
		case ALWAYS_DIRTY:
			editorInput.selectAll();
			doSetInitialDirty(editorInput, editor);
			break;
		case NEVER_DIRTY:
		default:
			break;
		}
	}

	/**
	 * Markiert den Editor und alle selektierten Items als dirty. Es klappt deshalb,
	 * weil unmittelbar nach dem Öffnen des Editors die Vorgabeseite automatisch
	 * selektiert ist.
	 *
	 * @param editorInput
	 *            das Input-Objekt
	 * @param editor
	 *            der Editor
	 */
	private void doSetInitialDirty(final ParameterEditorInput editorInput, final FormEditor editor) {
		final IFormPage formPage = (IFormPage) editor.getSelectedPage();
		if (null != formPage.getManagedForm()) {
			for (final IFormPart formPart : formPage.getManagedForm().getParts()) {
				if (formPart instanceof AbstractFormPart) {
					((AbstractFormPart) formPart).markDirty();
				}
			}
		}
		editorInput.getSelectedParameters().clear();
	}

}
