/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.handler;

import de.bsvrz.buv.plugin.param.provider.BetroffeneObjekteContentProvider;

/**
 * Handler für das Kommando der Ansicht
 * {@link de.bsvrz.buv.plugin.param.views.BetroffeneObjekteView}, mit der die
 * Anzeige der NICHT änderbaren Objekte ein- oder ausgeschaltet wird.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann, Uwe Peuker
 *
 */
public class BetroffeneObjekteAnzeigeUmschaltHandler extends AbstractBetroffeneObjekteAnzeigeUmschaltHandler {

	private static final String TOGGLE_COMMAND = "de.bsvrz.buv.plugin.param.actions.BetroffeneObjekteAnzeigeUmschaltAktion";

	@Override
	protected void callSetter(final BetroffeneObjekteContentProvider contentProvider, final boolean status) {
		contentProvider.setBetroffeneObjekteZeigen(status);
	}

	@Override
	protected String getToggleCommand() {
		return BetroffeneObjekteAnzeigeUmschaltHandler.TOGGLE_COMMAND;
	}
}
