/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.param.handler;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.QuellTyp;

/**
 * Tester für die Selektionen der KOmmandos zum Manipulieren von Parametern.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 */
public class HandlerTester extends PropertyTester {

	@Override
	public boolean test(final Object receiver, final String property, final Object[] args, final Object expectedValue) {

		boolean result = false;

		final IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		if (activeWorkbenchWindow != null) {
			final ISelection selection = activeWorkbenchWindow.getSelectionService().getSelection();
			if (selection instanceof IStructuredSelection) {
				final Parameter[] parameters = ParameterSelektion.getParameters((IStructuredSelection) selection);

				if ((parameters != null) && (parameters.length > 0)) {
					if ("bearbeiten".equals(property)) {
						result = pruefeBearbeiten(parameters);
					} else if ("ueberschreiben".equals(property)) {
						result = pruefeUeberschreiben(parameters);
					} else if ("entfernen".equals(property)) {
						result = pruefeEntfernen(parameters);
					} else if ("kopieren".equals(property)) {
						result = pruefeKopieren(parameters);
					} else if ("tauschen".equals(property)) {
						result = pruefeTauschen(parameters);
					}
				}
			}
		}
		return result;
	}

	private boolean pruefeTauschen(final Parameter[] parameters) {
		boolean result = parameters.length == 1;

		if (result) {
			for (final Parameter parameter : parameters) {
				result = parameter.isDataAvailable();
				if (result) {
					result = !parameter.getObjekt().equals(parameter.getQuelle().getObjekt());
				}
				if (!result) {
					break;
				}
			}
		}
		return result;
	}

	private boolean pruefeUeberschreiben(final Parameter[] parameters) {

		boolean result = true;

		for (final Parameter parameter : parameters) {
			result = parameter.isDataAvailable();
			if (result) {
				result = !parameter.getObjekt().equals(parameter.getQuelle().getObjekt());
			}
			if (!result) {
				break;
			}
		}
		return result;
	}

	private boolean pruefeBearbeiten(final Parameter[] parameters) {
		boolean result = true;
		for (final Parameter parameter : parameters) {
			result = parameter.isDataAvailable();
			if (result) {
				result = QuellTyp.DEFAULT_OBJEKT.equals(parameter.getQuelle().getTyp())
						|| QuellTyp.LOKAL_OBJEKT.equals(parameter.getQuelle().getTyp());
			}

			if (!result) {
				break;
			}
		}
		return result;
	}

	private boolean pruefeEntfernen(final Parameter[] parameters) {
		boolean result = true;
		for (final Parameter parameter : parameters) {
			result = parameter.isDataAvailable();
			if (result) {
				result = parameter.isDataAvailable() && QuellTyp.LOKAL_OBJEKT.equals(parameter.getQuelle().getTyp());
			}

			if (!result) {
				break;
			}
		}
		return result;
	}

	private boolean pruefeKopieren(final Parameter[] parameters) {
		boolean result = true;
		for (final Parameter parameter : parameters) {
			result = parameter.isDataAvailable();
			if (result) {
				result = parameter.isDataAvailable();
			}

			if (!result) {
				break;
			}
		}
		return result;
	}

}
