/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

import de.bsvrz.buv.plugin.param.provider.AbstractParamPluginContentProvider;
import de.bsvrz.buv.plugin.param.views.AbstractParamPluginView;
import de.bsvrz.puk.param.lib.Parameter;

/**
 * Abstrakter Handler für Kommandos, die innerhalb des Plug-ins Parametrierung
 * bereitgestellt werden.
 *
 * Die Klasse implementiert allgemeingültige Funktionen, die allen
 * Plug-in-Handlern gemeinsam sind.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann/Uwe Peuker
 *
 */
public abstract class ParamPluginHandler extends AbstractHandler {

	/**
	 * Die Methode versucht, den Contentprovider des {@link AbstractParamPluginView}
	 * zu finden, aus dem diese Aktion heraus aufgerufen wurde.
	 *
	 * @return der Contentprovider oder null
	 */
	protected AbstractParamPluginContentProvider findContentProvider() {
		AbstractParamPluginContentProvider contentProvider = null;
		final IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		if (window != null) {
			final IWorkbenchPart part = window.getActivePage().getActivePart();
			if (part instanceof AbstractParamPluginView) {
				final AbstractParamPluginView paramPluginView = (AbstractParamPluginView) part;
				final ContentViewer viewer = (ContentViewer) paramPluginView.getSite().getSelectionProvider();
				contentProvider = (AbstractParamPluginContentProvider) viewer.getContentProvider();
			}
		}
		return contentProvider;
	}

	/**
	 * Liefert die zu bearbeitenden/löschenden Parameter.
	 *
	 * @return die Parameter
	 */
	protected final Parameter[] getParameters(final ExecutionEvent event) {

		Parameter[] result = null;

		final ISelection selection = HandlerUtil.getCurrentSelection(event);
		if (selection instanceof IStructuredSelection) {
			result = ParameterSelektion.getParameters((IStructuredSelection) selection);
		}

		return result;
	}
}
