/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.param.handler;

import java.util.List;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;

import de.bsvrz.buv.plugin.param.editors.IParameterFormPageFactory;
import de.bsvrz.buv.plugin.param.editors.ParameterEditor;
import de.bsvrz.buv.plugin.param.editors.ParameterEditorAuswahlDialog;
import de.bsvrz.buv.plugin.param.editors.ParameterEditorInput;
import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterClientException;

/**
 * Handler für das Kommando zum Öffnen des Editors zum Bearbeiten eines oder
 * mehrerer {@link de.bsvrz.puk.param.lib.Parameter}.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann, Uwe Peuker
 *
 */
public class ParameterBearbeitenHandler extends AbstractParameterModifizierenHandler {

	public static final String COMMAND_ID = "de.bsvrz.buv.plugin.param.actions.ParameterBearbeitenAktion";

	@Override
	public Object execute(final ExecutionEvent event) throws ExecutionException {
		final Parameter[] parameters = getParameters(event);
		if (parameters == null) {
			return null;
		}

		bearbeiten(parameters);
		return null;
	}

	public void bearbeiten(final Parameter[] parameters) {
		Cursor waitCursor = null;
		final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
		try {
			if (null != shell) {
				waitCursor = new Cursor(Display.getDefault(), SWT.CURSOR_WAIT);
				shell.setCursor(waitCursor);
			}

			final ParameterEditorInput editorInput = new ParameterEditorInput(parameters, findContentProvider());
			final IParameterFormPageFactory selectedFactory;
			final List<IParameterFormPageFactory> factories = editorInput.determineApplicableEditors();
			Assert.isTrue(factories.size() > 0,
					"Es gibt leider keine Editoren zum Bearbeiten der\n" + editorInput.getShortText());
			if (factories.size() > 1) {
				final ParameterEditorAuswahlDialog dialog = new ParameterEditorAuswahlDialog(shell, factories,
						factories.get(editorInput.getBestFactory(factories)));
				if (Window.OK == dialog.open()) {
					selectedFactory = dialog.getSelectedFactory();
				} else {
					return;
				}
			} else {
				/*
				 * Standardfall - es gibt nur einen registrierten Editor, den Standardeditor,
				 * den öffnen wir
				 */
				selectedFactory = factories.get(0);
			}
			if ((null != shell) && (null != waitCursor)) {
				shell.setCursor(waitCursor);
			}
			editorInput.setAttributePropagationMode(selectedFactory.getDefaultAttributePropagationMode());
			editorInput.setSelectedFactory(selectedFactory);
			final IEditorPart partReallyCreated = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()
					.openEditor(editorInput, ParameterEditor.EDITOR_ID);
			if (partReallyCreated instanceof FormEditor) {
				final FormEditor editor = (FormEditor) partReallyCreated;
				// HINWEIS An dieser Stelle kann man den Default
				// InitialDirtyStateMode aus einer Preference Page o.ä. auslesen
				// und
				// setzen.
				// InitialDirtyStateMode mode =
				// getInitialDirtyStateModeFromSomewhere();
				// editorInput.setInitialDirtyStateMode(mode);
				applyInitialDirtyState(editorInput, editor);
			} else if (partReallyCreated != null) {
				PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(partReallyCreated,
						false);
			}
		} catch (final PartInitException e) {
			ParamPlugin.getDefault().getLogger().error("Fehler beim Öffnen des Parametereditors", e);
		} catch (final ParameterClientException e) {
			ParamPlugin.getDefault().getLogger().error(
					"Fehler bei Kommunikation mit Parametrierung" + " während des Öffnens des Parametereditors", e);
		} finally {
			if (null != shell) {
				shell.setCursor(null);
			}
			if (null != waitCursor) {
				waitCursor.dispose();
				waitCursor = null;
			}
		}
	}
}
