/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.handlers.HandlerUtil;

import de.bsvrz.buv.plugin.param.editors.AbstractParameterFormPage;
import de.bsvrz.buv.plugin.param.editors.ParameterEditor;

/**
 * CommandHandler zum Exportieren von Parametern via Shortcut CTRL+E.
 * Idealerweise ist dabei der momentan aktive Editor der {@link ParameterEditor}
 * .
 *
 * Credits to Christian Hösel for finding out how to do this.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
public class ParameterExportCommand extends AbstractHandler {

	@Override
	public Object execute(final ExecutionEvent event) throws ExecutionException {
		final IWorkbenchPart part = HandlerUtil.getActivePart(event);
		if (part instanceof ParameterEditor) {
			final IFormPage activePage = ((ParameterEditor) part).getActivePageInstance();
			if (activePage instanceof AbstractParameterFormPage) {
				final IAction exportAction = ((AbstractParameterFormPage) activePage).getExportAction();
				if (null != exportAction) {
					exportAction.run();
				}
			}

		}
		return null;
	}

}
