/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.param.handler;

import java.util.Collection;

import org.eclipse.jface.viewers.IStructuredSelection;

import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterInfo;

/**
 * Hilfsklasse zum Ermitteln einer Selektion von Parametern in den Ansichten des
 * Parameter-Plugins.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 */
public final class ParameterSelektion {

	/** provater Konstruktor. */
	private ParameterSelektion() {
		// es werden keine Objekte der Klasse angelegt
	}

	public static Parameter[] getParameters(final IStructuredSelection selection) {

		Parameter[] result = null;

		final Object objekt = selection.getFirstElement();
		Object[] selectedObjects = null;
		if (objekt instanceof Object[]) {
			selectedObjects = (Object[]) objekt;
		} else if (objekt instanceof Collection<?>) {
			selectedObjects = ((Collection<?>) objekt).toArray();
		} else {
			selectedObjects = selection.toArray();
		}

		final Parameter[] neueParameter = new Parameter[selectedObjects.length];
		boolean oneValidObjectFound = false;
		boolean allObjectsValid = true;
		for (int loop = 0; loop < neueParameter.length; ++loop) {
			if (selectedObjects[loop] instanceof Parameter) {
				neueParameter[loop] = (Parameter) selectedObjects[loop];
				oneValidObjectFound = true;
			} else if (selectedObjects[loop] instanceof ParameterInfo) {
				neueParameter[loop] = new Parameter((ParameterInfo) selectedObjects[loop]);
				oneValidObjectFound = true;
			} else {
				if (oneValidObjectFound) {
					ParamPlugin.getDefault().getLogger()
							.error("Ein Objekt vom Typ '" + selectedObjects[loop].getClass().getName()
									+ "' kann innerhalb der Aktionsklasse '"
									+ selectedObjects[loop].getClass().getName() + "' nicht verarbeitet werden");
				}
				// else {
				// Kommt ständig vor, da der Selektionslistener
				// dauernd aufgerufen wird
				// }
				allObjectsValid = false;
				break;
			}
		}
		if (allObjectsValid) {
			result = neueParameter;
		}

		return result;
	}
}
