/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.handler;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.buv.plugin.param.lib.ParameterManagerAllgemein;
import de.bsvrz.buv.plugin.param.views.AbstractParameterKopierenView;
import de.bsvrz.buv.plugin.param.views.ParameterTauschenView;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterClientException;

/**
 * Handler für das Kommando zum Tauschen zweier Parameter. Diese Aktion ist dann
 * verfügbar, wenn man ein Objekt auswählt, dessen Daten ungleich null und nicht
 * historisch sind
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann, Uwe Peuker
 *
 */
public class ParameterTauschenHandler extends ParamPluginHandler {

	public static final String COMMAND_ID = "de.bsvrz.buv.plugin.param.actions.ParameterTauschenAktion";

	@Override
	public Object execute(final ExecutionEvent event) throws ExecutionException {

		final Parameter[] parameters = getParameters(event);
		if ((parameters == null) || (parameters.length != 1)) {
			return null;
		}

		final String id = ParameterTauschenView.ID;

		try {
			final IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(id,
					AbstractParameterKopierenView.buildSecondaryId(parameters), IWorkbenchPage.VIEW_ACTIVATE);
			if (part instanceof AbstractParameterKopierenView) {
				final AbstractParameterKopierenView kopierenViewPart = (AbstractParameterKopierenView) part;
				kopierenViewPart.setInput(ParameterManagerAllgemein.getFilledParameterArray(parameters));
			}
		} catch (final PartInitException e) {
			ParamPlugin.getDefault().getLogger().error(e.getLocalizedMessage(), e);
		} catch (final ParameterClientException e) {
			ParamPlugin.getDefault().getLogger().error(e.getLocalizedMessage(), e);
		}

		return null;
	}
}
