/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.handler;

import java.util.Map;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.RegistryToggleState;
import org.eclipse.ui.menus.UIElement;

import de.bsvrz.buv.plugin.param.views.AbstractParamPluginView;
import de.bsvrz.buv.plugin.selektion.SelektionsTransfer;

/**
 * Handler für das Kommando zum Ein- und Ausschalten der Fähigkeit, Selektionen
 * zu empfangen (Mantis#1547,1270).
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann, Uwe Peuker
 *
 */
public class ToggleSelektionEmpfangenHandler extends AbstractHandler implements IElementUpdater {

	private static final String TOGGLE_COMMAND = "de.bsvrz.buv.plugin.param.actions.ToggleSelektionEmpfangenAction";

	@Override
	public Object execute(final ExecutionEvent event) throws ExecutionException {

		final boolean toggleCommandState = HandlerUtil.toggleCommandState(event.getCommand());
		final IWorkbenchPart activePart = HandlerUtil.getActivePart(event);

		if (activePart instanceof AbstractParamPluginView) {
			((AbstractParamPluginView) activePart).setSelektionEmpfangen(!toggleCommandState);
			if (!toggleCommandState) {
				final IStructuredSelection s = SelektionsTransfer.getInstanz().getVorherigeSelection();
				((AbstractParamPluginView) activePart).selectionChanged(null, s);
			}

			final ICommandService service = PlatformUI.getWorkbench().getService(ICommandService.class);
			service.refreshElements(event.getCommand().getId(), null);
		}

		return null;
	}

	@Override
	public void updateElement(final UIElement element, final Map parameters) {
		final ICommandService service = PlatformUI.getWorkbench().getService(ICommandService.class);
		final Command command = service.getCommand(ToggleSelektionEmpfangenHandler.TOGGLE_COMMAND);
		final State state = command.getState(RegistryToggleState.STATE_ID);
		element.setChecked((Boolean) state.getValue());
	}
}
