/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.internal;

import java.io.IOException;

import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import com.bitctrl.lib.eclipse.AbstractBitCtrlPlugin;

import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungsAdresse;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;

/**
 * The activator class controls the plug-in life cycle.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
public class ParamPlugin extends AbstractBitCtrlPlugin {

	/** Die plug-in ID. */
	public static final String PLUGIN_ID = "de.bsvrz.buv.plugin.param";

	/**
	 * Die einzige Instanz.
	 */
	private static ParamPlugin plugin;

	/**
	 * True, wenn die Aufrufe an
	 * {@link de.bsvrz.buv.plugin.param.provider.AbstractParamPluginContentProvider#reloadCurrentInput(boolean)}
	 * in einem Job erfolgen sollen, false sonst.
	 */
	private boolean usingReloadJobs;

	/*
	 * (non-Javadoc)
	 *
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.
	 * BundleContext )
	 */
	@Override
	public void start(final BundleContext context) throws Exception {
		super.start(context);
		ParamPlugin.plugin = this;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.
	 * BundleContext )
	 */
	@Override
	public void stop(final BundleContext context) throws Exception {
		ParamPlugin.plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance.
	 *
	 * @return the shared instance
	 */
	public static ParamPlugin getDefault() {
		return ParamPlugin.plugin;
	}

	/**
	 * Liefert true, wenn die Aufrufe an
	 * {@link de.bsvrz.buv.plugin.param.provider.AbstractParamPluginContentProvider#reloadCurrentInput(boolean)}
	 * in einem Job erfolgen sollen, false sonst.
	 *
	 * @return Jobs benutzen?
	 */
	public boolean isUsingReloadJobs() {
		return usingReloadJobs;
	}

	/**
	 * Liefert den Wert der lokalen allgemeinen Einstellung property. Falls diese
	 * nicht existiert, aber defaultValue ungleich <code>null</code> ist, so wird
	 * dieser zurückgegeben UND dieser Wert auch in die lokalen allgemeinen
	 * Einstellungen geschrieben.
	 *
	 * @param property
	 *            Die Property. darf nicht null sein.
	 * @param defaultValue
	 *            Default-Wert für property.
	 *
	 * @return der Wert. Kann <code>null</code> sein (siehe Text)
	 */
	public String getLokalenParameter(final String property, final String defaultValue) {
		final String value;

		final EinstellungsAdresse adresse = new EinstellungsAdresse(null, property, SpeicherKey.allgemeinLokal());
		String parameterRead = null;
		try {
			parameterRead = (String) RahmenwerkService.getService().getEinstellungen().getValue(adresse);
		} catch (final IOException e) {
			// Wert konnte nicht gelesen werden
		}
		if (parameterRead == null) {
			value = defaultValue;
			final String msg1 = "Parameter mit Id '" + property + "' war nicht gesetzt";
			try {
				RahmenwerkService.getService().getEinstellungen().setValue(adresse, value);
				getLogger().info(msg1 + ", wurde auf Defaultwert '" + defaultValue + "' gesetzt");
			} catch (final IOException e) {
				getLogger().warning(msg1 + ", konnte nicht auf Defaultwert '" + defaultValue + "' gesetzt werden");
			}
		} else {
			value = parameterRead;
		}
		return value;
	}
}
