/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.buv.plugin.param.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.provider.AbstractParamPluginContentProvider;
import de.bsvrz.puk.param.lib.MethodenBibliothek;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterClientException;
import de.bsvrz.puk.param.lib.daten.DataWithTime;

/**
 * Job zum Löschen eines oder mehrerer Parametersatzes/-sätze und zum
 * Aktualisieren der Ansicht
 * {@link de.bsvrz.buv.plugin.param.views.BetroffeneObjekteView}.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
public class ParameterEntfernenJob extends Job {

	/**
	 * der bzw. die zu löschende(n) Parameter.
	 */
	private final Parameter[] parameters;

	/**
	 * Objekt, welches nach Löschen des Parameters zu aktualisieren ist, oder null.
	 */
	private final AbstractParamPluginContentProvider contentProvider;

	/**
	 * Konstruktor setzt und validiert Member.
	 *
	 * @param contentProvider
	 *            Objekt, welches nach Löschen des Parameters zu aktualisieren ist,
	 *            oder null
	 * @param parameters
	 *            der bzw. die zu löschende(n) Parameter
	 */
	public ParameterEntfernenJob(final AbstractParamPluginContentProvider contentProvider,
			final Parameter... parameters) {
		super("Parameter löschen");
		this.parameters = parameters;
		this.contentProvider = contentProvider;
		assert parameters != null;
		assert parameters.length > 0;
	}

	@Override
	public IStatus run(final IProgressMonitor monitor) {
		IStatus status = Status.OK_STATUS;
		try {
			for (final Parameter p : parameters) {
				p.setDataWithTime(new DataWithTime(null, 0));
			}
			MethodenBibliothek.getParameterManager(RahmenwerkService.getService().getObjektFactory().getDav())
					.setParameter(parameters);
			if (contentProvider != null) {
				contentProvider.reloadCurrentInput(true);
			}
		} catch (final ParameterClientException e) {
			ParamPlugin.getDefault().getLogger().error("Fehler beim Löschen eines Parameters", e);
			status = new Status(IStatus.ERROR, ParamPlugin.PLUGIN_ID, e.getLocalizedMessage(), e);
		}
		return status;
	}

}
