/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.perspective;

import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

import de.bsvrz.buv.plugin.param.views.ArtDesParametersatzesView;
import de.bsvrz.buv.plugin.param.views.BetroffeneObjekteView;
import de.bsvrz.buv.plugin.param.views.ObjektauswahlView;
import de.bsvrz.buv.plugin.param.views.ParameterKopierenView;
import de.bsvrz.buv.plugin.param.views.ParametertypenView;

/**
 * Masterklasse für die Perspektive "Parametrierung".
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
public class ParamPluginPerspektive implements IPerspectiveFactory {

	@Override
	public void createInitialLayout(final IPageLayout layout) {
		final String editorArea = layout.getEditorArea();
		layout.setEditorAreaVisible(true);

		layout.addView(ParametertypenView.ID, IPageLayout.LEFT, 0.3f, editorArea);
		layout.addView(BetroffeneObjekteView.ID, IPageLayout.BOTTOM, 0.5f, editorArea);
		layout.addView(ObjektauswahlView.ID, IPageLayout.BOTTOM, 0.4f, ParametertypenView.ID);
		layout.addView(ArtDesParametersatzesView.ID, IPageLayout.BOTTOM, 0.65f, ObjektauswahlView.ID);
		layout.addPlaceholder(ParameterKopierenView.ID, IPageLayout.BOTTOM, 0.7f, editorArea);
	}
}
