/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.provider;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;

/**
 * Abstrakte Superklasse für die Labelprovider der Ansichten des Plug-in
 * "Parametrierung".
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
public abstract class AbstractParamPluginLabelProvider implements IBaseLabelProvider {

	/**
	 * Trennzeichen für verschiedene Eigenschaften, die in einer Zeile angezeigt
	 * werden, aber potentiell ein- und ausblendbar sind.
	 */
	protected static final String EIGENSCHAFTEN_SEPARATOR = " - ";

	/**
	 * ermittelt, ob die Konfigurationsbereiche der dargestellten Objekte angezeigt
	 * werden sollen.
	 */
	private boolean konfigurationsBereicheAnzeigen;

	/**
	 * ermittelt, ob die Systemobjekttypen der dargestellten Parametertypen
	 * (=Attributgruppen) angezeigt werden sollen.
	 */
	private boolean systemObjektTypenAnzeigen;

	@Override
	public void addListener(final ILabelProviderListener listener) {
		// leer
	}

	@Override
	public void dispose() {
		// leer
	}

	@Override
	public boolean isLabelProperty(final Object element, final String property) {
		return false;
	}

	@Override
	public void removeListener(final ILabelProviderListener listener) {
		// leer
	}

	/**
	 * ermittelt, ob die Konfigurationsbereiche der dargestellten Objekte angezeigt
	 * werden sollen.
	 *
	 * @return <code>true</code>, wenn die Konfigurationsbereiche angezeigt werden
	 *         sollen
	 */
	public boolean isKonfigurationsBereicheAnzeigen() {
		return konfigurationsBereicheAnzeigen;
	}

	/**
	 * markiert, ob die Konfigurationsbereiche der dargestellten Objekte angezeigt
	 * werden sollen.
	 *
	 * @param konfigurationsBereicheAnzeigen
	 *            <code>true</code>, wenn die Konfigurationsbereiche angezeigt
	 *            werden sollen
	 */
	public void setKonfigurationsBereicheAnzeigen(final boolean konfigurationsBereicheAnzeigen) {
		this.konfigurationsBereicheAnzeigen = konfigurationsBereicheAnzeigen;
	}

	/**
	 * ermittelt, ob die Systemobjekttypen der dargestellten Parametertypen
	 * (=Attributgruppen) angezeigt werden sollen.
	 *
	 * @return <code>true</code>, wenn die Systemobjekttypen angezeigt werden sollen
	 */
	public boolean isSystemObjektTypenAnzeigen() {
		return systemObjektTypenAnzeigen;
	}

	/**
	 * bestimmt, ob die Systemobjekttypen der dargestellten Parametertypen
	 * (=Attributgruppen) angezeigt werden sollen.
	 *
	 * @param systemObjektTypenAnzeigen
	 *            <code>true</code>, wenn die Systemobjekttypen angezeigt werden
	 *            sollen
	 */
	public void setSystemObjektTypenAnzeigen(final boolean systemObjektTypenAnzeigen) {
		this.systemObjektTypenAnzeigen = systemObjektTypenAnzeigen;
	}

}
