/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.provider;

import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;

import de.bsvrz.buv.plugin.param.Zeichenketten;
import de.bsvrz.buv.plugin.param.views.AbstractParamPluginView;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterClientException;

/**
 * Contentprovider für einen Viewer vom Typ
 * {@link de.bsvrz.buv.plugin.param.viewer.MehrereParameterKopierenViewer}.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
public class MehrereParameterKopierenContentProvider extends AbstractParamPluginContentProvider {

	/**
	 * Default-Kurzinfo, falls keine Objekte geladen sind.
	 */
	private static final String DEFAULT_KURZINFO = "Mehrere Parameter kopieren: "
			+ Zeichenketten.PARAM_PLUGIN_HINWEIS_KEINE_QUELLE;

	/**
	 * Aktueller Input, ein Feld von Parametern.
	 */
	private Parameter[] currentInput;

	/**
	 * Konstruktor reicht durch und setzt eine Default-Kurzinfo für die Ansicht.
	 *
	 * @param paramPluginView
	 *            der View, in dem wir uns befinden.
	 */
	public MehrereParameterKopierenContentProvider(final AbstractParamPluginView paramPluginView) {
		super(paramPluginView);
		setKurzinfo(DEFAULT_KURZINFO);
	}

	@Override
	public void inputChanged(final Viewer viewer, final Object oldInput, final Object newInput) {
		super.inputChanged(viewer, oldInput, newInput);
		if (newInput instanceof Parameter[]) {
			final Parameter[] parameters = (Parameter[]) newInput;
			currentInput = parameters;
			setKurzinfo("Insgesamt " + currentInput.length + " Quellobjekte");
		} else {
			currentInput = null;
			setKurzinfo(DEFAULT_KURZINFO);
		}
	}

	@Override
	public void reloadCurrentInput(final boolean doRefreshViewer) throws ParameterClientException {
		// HINWEIS wie in BetroffeneObjekteContentProvider
	}

	@Override
	public Object[] getElements(final Object inputElement) {
		if (null == currentInput) {
			return new Object[0];
		}
		return currentInput;
	}

	@Override
	public void selectionChanged(final SelectionChangedEvent event) {
		// leer
	}

}
