/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.provider;

import java.util.Set;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;

import de.bsvrz.buv.plugin.param.ModifiableParameterInfo;
import de.bsvrz.buv.plugin.param.ParametertypenCache;
import de.bsvrz.buv.plugin.param.Zeichenketten;
import de.bsvrz.buv.plugin.param.views.AbstractParamPluginView;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterClientException;

/**
 * ContentProvider für einen
 * {@link de.bsvrz.buv.plugin.param.viewer.ParameterKopierenViewer}.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
public class ParameterKopierenContentProvider extends AbstractParamPluginContentProvider
		implements ITreeContentProvider {

	/**
	 * Default-Kurzinfo, falls kein Objekt geladen ist.
	 */
	private static final String DEFAULT_KURZINFO = "Parameter kopieren: "
			+ Zeichenketten.PARAM_PLUGIN_HINWEIS_KEINE_QUELLE;

	/**
	 * Aktueller Input, ein Parameter.
	 */
	private Parameter currentInput;

	/**
	 * letzte gültige Inputs.
	 */
	private ModifiableParameterInfo lastValidInputDescription;

	/**
	 * Konstruktor reicht durch und setzt eine Default-Kurzinfo für die Ansicht.
	 *
	 * @param paramPluginView
	 *            der View, in dem wir uns befinden.
	 */
	public ParameterKopierenContentProvider(final AbstractParamPluginView paramPluginView) {
		super(paramPluginView);
		setKurzinfo(DEFAULT_KURZINFO);
	}

	@Override
	public void inputChanged(final Viewer viewer, final Object oldInput, final Object newInput) {
		super.inputChanged(viewer, oldInput, newInput);
		if (newInput instanceof Parameter[]) {
			final Parameter[] parameters = (Parameter[]) newInput;
			currentInput = parameters[0];
			lastValidInputDescription = new ModifiableParameterInfo();
			lastValidInputDescription.setAtg(currentInput.getAtg());
			// HINWEIS ...setHistorisch(currentInput.isHistorisch())
			lastValidInputDescription.setHistorisch(false);
			lastValidInputDescription.setObjekt(currentInput.getObjekt());
			lastValidInputDescription.setSim(currentInput.getSim());
			lastValidInputDescription.addTyp(currentInput.getTyp());
			setKurzinfo("Von: " + currentInput.getObjekt().toString() + ", Attributgruppe: "
					+ currentInput.getAtg().toString());
		} else {
			currentInput = null;
			setKurzinfo(DEFAULT_KURZINFO);
		}
	}

	@Override
	public void reloadCurrentInput(final boolean doRefreshViewer) throws ParameterClientException {
		/*
		 * HINWEIS über die Methodenbibliothek oder Archiv die Data des Parameter-Input
		 * neu laden
		 */
	}

	@Override
	public Object[] getElements(final Object inputElement) {
		Object[] elements;
		if (inputElement instanceof Parameter[]) {
			final Parameter[] parameters = (Parameter[]) inputElement;
			final Set<SystemObjectType> parents = ParametertypenCache.getInstanz().getParents(parameters[0].getAtg());
			elements = parents.toArray();
		} else {
			elements = new Object[0];
		}
		return elements;
	}

	@Override
	public void selectionChanged(final SelectionChangedEvent event) {
		// vorerst nichts zu tun
	}

	@Override
	public Object[] getChildren(final Object parentElement) {
		Object[] result = null;
		if (parentElement instanceof SystemObjectType) {
			final SystemObjectType type = (SystemObjectType) parentElement;
			result = type.getElements().toArray();
		} else {
			result = new Object[0];
		}
		return result;
	}

	@Override
	public Object getParent(final Object element) {
		Object parent = null;
		if (element instanceof SystemObject) {
			final SystemObject object = (SystemObject) element;
			parent = object.getType();
		}
		return parent;
	}

	@Override
	public boolean hasChildren(final Object element) {
		boolean result = false;
		if (element instanceof SystemObjectType) {
			final SystemObjectType type = (SystemObjectType) element;
			result = !type.getElements().isEmpty();
		}
		return result;
	}

}
