/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.provider;

import de.bsvrz.buv.plugin.param.provider.helper.AbstractParamPluginViewerSorter;
import de.bsvrz.puk.param.lib.Parameter;

/**
 * Sortierer für {@link Parameter}.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 *
 */
public class ParameterSorter extends AbstractParamPluginViewerSorter {

	/**
	 * Die erweiterte Compare-Methode, welche die in der Table gespeicherten
	 * Informationen zur Sortierspalte und zur Sortierrichtung berücksichtigt.
	 *
	 * Die Default-Implementierung vergleicht die Ergebnisse von
	 * {@link Object#toString()}.
	 *
	 * Unbedingt überschreiben!
	 *
	 * @param criteria
	 *            das Sortierkriterium, also z.B. der Name der Spalte, nach der
	 *            sortiert wird
	 * @param down
	 *            true wenn absteigend sortiert wird, false wenn aufsteigend
	 * @param e1
	 *            Objekt 1
	 * @param e2
	 *            Objekt 2
	 * @return 0: Objekte sind identisch, 1: e1 ist größer als e2, 2: e1 ist kleiner
	 *         als e2
	 */
	@Override
	protected int compare(final String criteria, final boolean down, final Object e1, final Object e2) {
		int result = 0;
		if (e1 instanceof Parameter && e2 instanceof Parameter) {
			final Parameter parameter1 = (Parameter) e1;
			final Parameter parameter2 = (Parameter) e2;
			if (AbstractParamPluginTableLabelProvider.COLUMNID_OBJECT_NAME.equals(criteria)) {
				result = compareSystemObjects(false, down, parameter1.getObjekt(), parameter2.getObjekt());
			} else if (AbstractParamPluginTableLabelProvider.COLUMNID_OBJECT_PID.equals(criteria)) {
				result = compareSystemObjects(true, down, parameter1.getObjekt(), parameter2.getObjekt());
			} else if (AbstractParamPluginTableLabelProvider.COLUMNID_ATG_NAME.equals(criteria)) {
				result = compareSystemObjects(false, down, parameter1.getAtg(), parameter2.getAtg());
			} else if (AbstractParamPluginTableLabelProvider.COLUMNID_ATG_PID.equals(criteria)) {
				result = compareSystemObjects(true, down, parameter1.getAtg(), parameter2.getAtg());
			} else if (AbstractParamPluginTableLabelProvider.COLUMNID_TYP_NAME.equals(criteria)) {
				result = compareSystemObjects(false, down, parameter1.getTyp(), parameter2.getTyp());
			} else if (AbstractParamPluginTableLabelProvider.COLUMNID_TYP_PID.equals(criteria)) {
				result = compareSystemObjects(true, down, parameter1.getTyp(), parameter2.getTyp());
			} else if (AbstractParamPluginTableLabelProvider.COLUMNID_QUELLE.equals(criteria)) {
				result = compareSystemObjects(true, down, parameter1.getQuelle().getObjekt(),
						parameter2.getQuelle().getObjekt());
			} else if (AbstractParamPluginTableLabelProvider.COLUMNID_QUELLTYP.equals(criteria)) {
				result = super.compare(criteria, down, parameter1.getQuelle().getTyp(),
						parameter2.getQuelle().getTyp());
			} else {
				result = super.compare(criteria, down, parameter1, parameter2);
			}
		} else {
			result = super.compare(criteria, down, e1, e2);
		}
		return down ? -result : result;
	}

}
