/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.provider;

import java.util.List;
import java.util.Set;

import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.buv.plugin.param.ParametertypenCache;
import de.bsvrz.buv.plugin.param.views.AbstractParamPluginView;
import de.bsvrz.buv.plugin.param.views.ObjektauswahlView;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.puk.param.lib.ParameterClientException;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.objekte.AutarkeOrganisationsEinheit;

/**
 * Contentprovider für den TreeViewer in der Ansicht
 * {@link de.bsvrz.buv.plugin.param.views.ParametertypenView}. Er stellt nur
 * konfigurierende Daten dar, ist also statisch, und versorgt sich über dne
 * {@link ParametertypenCache}.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 */
public class ParametertypenContentProvider extends AbstractParamPluginContentProvider implements ITreeContentProvider {

	/**
	 * Konstruktor reicht durch und setzt eine Default-Kurzinfo für die Ansicht.
	 *
	 * @param paramPluginView
	 *            der View, in dem wir uns befinden.
	 */
	public ParametertypenContentProvider(final AbstractParamPluginView paramPluginView) {
		super(paramPluginView);
		setKurzinfo("Parametertyp=Attributgruppe");
	}

	@Override
	public Object[] getElements(final Object inputElement) {
		Object[] result = null;
		if ((inputElement instanceof ParametertypenCache) || (inputElement instanceof AutarkeOrganisationsEinheit)) {
			final Set<ConfigurationArea> kbs = ParametertypenCache.getInstanz().getConfigurationAreas();
			if (kbs != null) {
				result = kbs.toArray();
			}
		} else if (inputElement instanceof ConfigurationArea) {
			final ConfigurationArea kb = (ConfigurationArea) inputElement;
			final List<SystemObjectType> types = ParametertypenCache.getInstanz().getSystemObjects(kb);
			result = types.toArray();
		} else if (inputElement instanceof SystemObjectType) {
			final SystemObjectType type = (SystemObjectType) inputElement;
			final List<AttributeGroup> atgs = ParametertypenCache.getInstanz().getAttributeGroups(type);
			if (atgs != null) {
				result = atgs.toArray();
			}
		}
		return result;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see de.bsvrz.buv.plugin.param.provider.AbstractParamPluginContentProvider
	 * #inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object,
	 * java.lang.Object)
	 */
	@Override
	public void inputChanged(final Viewer viewer, final Object oldInput, final Object newInput) {
		super.inputChanged(viewer, oldInput, newInput);
		refreshViewer();
	}

	@Override
	public Object[] getChildren(final Object parentElement) {
		Object[] result = null;
		if (parentElement instanceof ParametertypenCache) {
			final Set<ConfigurationArea> kbs = ParametertypenCache.getInstanz().getConfigurationAreas();
			if (kbs != null) {
				result = kbs.toArray();
			}
		} else if (parentElement instanceof ConfigurationArea) {
			final ConfigurationArea kb = (ConfigurationArea) parentElement;
			final List<SystemObjectType> types = ParametertypenCache.getInstanz().getSystemObjects(kb);
			result = types.toArray();
		} else if (parentElement instanceof SystemObjectType) {
			final SystemObjectType type = (SystemObjectType) parentElement;
			final List<AttributeGroup> atgs = ParametertypenCache.getInstanz().getAttributeGroups(type);
			if (atgs != null) {
				result = atgs.toArray();
			}
		}
		return result;
	}

	@Override
	public Object getParent(final Object element) {
		Object parent = null;
		if (element instanceof SystemObjectType) {
			final SystemObjectType type = (SystemObjectType) element;
			parent = type.getConfigurationArea();
		}
		// else if (element instanceof AttributeGroup) {
		// ((AttributeGroup) element).get
		// }
		return parent;
	}

	@Override
	public boolean hasChildren(final Object element) {
		boolean result = false;
		if (element instanceof ParametertypenCache) {
			final Set<ConfigurationArea> kbs = ParametertypenCache.getInstanz().getConfigurationAreas();
			if ((kbs != null) && !kbs.isEmpty()) {
				result = true;
			}
		} else if (element instanceof ConfigurationArea) {
			final ConfigurationArea kb = (ConfigurationArea) element;
			final List<SystemObjectType> types = ParametertypenCache.getInstanz().getSystemObjects(kb);
			if (!types.isEmpty()) {
				result = true;
			}
		} else if (element instanceof SystemObjectType) {
			final SystemObjectType type = (SystemObjectType) element;
			final List<AttributeGroup> atgs = ParametertypenCache.getInstanz().getAttributeGroups(type);
			if ((atgs != null) && !atgs.isEmpty()) {
				result = true;
			}
		} /*
			 * else if (element instanceof AttributeGroup) { ... ATGs never have children!
			 */
		return result;
	}

	@Override
	public void selectionChanged(final SelectionChangedEvent event) {
		final IViewPart objektauswahlView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()
				.findView(ObjektauswahlView.ID);
		if (objektauswahlView != null) {
			if (!event.getSelection().isEmpty() && (event.getSelection() instanceof IStructuredSelection)
					&& (((IStructuredSelection) event.getSelection()).getFirstElement() instanceof AttributeGroup)) {
				final AttributeGroup atg = (AttributeGroup) ((IStructuredSelection) event.getSelection())
						.getFirstElement();
				final ISelectionProvider p = objektauswahlView.getSite().getSelectionProvider();
				if (p instanceof ContentViewer) {
					final ContentViewer viewer = (ContentViewer) p;
					viewer.setInput(atg);
				}
			}
		}

	}

	@Override
	public void reloadCurrentInput(final boolean doRefreshViewer) throws ParameterClientException {
		// Default-Implementierung
		if (doRefreshViewer) {
			refreshViewer();
		}
	}
}
