/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.provider.helper;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.TableColumn;

import de.bsvrz.dav.daf.main.config.SystemObject;

/**
 * Allgemeiner Sortierer für DaV-Plug-ins.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 *
 */
public class AbstractParamPluginViewerSorter extends ViewerComparator {

	/**
	 * Die erweiterte Compare-Methode, welche die in der Table gespeicherten
	 * Informationen zur Sortierspalte und zur Sortierrichtung.
	 *
	 * Die Default-Implementierung vergleicht die Ergebnisse von
	 * {@link Object#toString()}.
	 *
	 * Unbedingt überschreiben!
	 *
	 * @param criteria
	 *            das Sortierkriterium, also z.B. der Name der Spalte, nach der
	 *            sortiert wird
	 * @param down
	 *            true wenn absteigend sortiert wird, false wenn aufsteigend
	 * @param e1
	 *            Objekt 1
	 * @param e2
	 *            Objekt 2
	 * @return 0: Objekte sind identisch, 1: e1 ist größer als e2, 2: e1 ist kleiner
	 *         als e2
	 */
	protected int compare(final String criteria, final boolean down, final Object e1, final Object e2) {
		int result = 0;
		if (e1 != null && e2 == null) {
			result = 1;
		} else if (e1 == null && e2 != null) {
			result = -1;
		} else if (e1 != null && e2 != null) {
			final String s1 = e1.toString();
			final String s2 = e2.toString();
			result = s1.compareTo(s2);
			if (result > 0) {
				result = 1;
			} else if (result < 0) {
				result = -1;
			}
		}
		return result;
	}

	/**
	 * Vergleicht Systemobjekte.
	 *
	 * @param byPid
	 *            Vergleich nach Pid, ansonsten nach Name
	 * @param down
	 *            Sortierrichtung
	 * @param sysObj1
	 *            Systemobjekt 1 (darf nicht <code>null</code> sein)
	 * @param sysObj2
	 *            Systemobjekt 2 (darf nicht <code>null</code> sein)
	 * @return 0: Objekte sind identisch, 1: e1 ist größer als e2, 2: e1 ist kleiner
	 *         als e2
	 */
	protected int compareSystemObjects(final boolean byPid, final boolean down, final SystemObject sysObj1,
			final SystemObject sysObj2) {
		int result = 0;
		if (byPid) {
			result = sysObj1.getPid().compareTo(sysObj2.getPid());
		} else {
			result = sysObj1.toString().compareTo(sysObj2.toString());
		}
		return result;
	}

	/*
	 * (Kein Javadoc)
	 *
	 * @see org.eclipse.jface.viewers.ViewerComparator#compare(org.eclipse.jface.
	 * viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	@Override
	public int compare(final Viewer viewer, final Object e1, final Object e2) {
		int result = 0;
		if (viewer instanceof TableViewer) {
			final TableColumn column = ((TableViewer) viewer).getTable().getSortColumn();
			if (column != null) {
				final String criteria = column.getText();
				final int sortDir = ((TableViewer) viewer).getTable().getSortDirection();
				final boolean down = sortDir == SWT.DOWN;
				result = compare(criteria, down, e1, e2);
			} else {
				result = super.compare(viewer, e1, e2);
			}
		} else {
			result = super.compare(viewer, e1, e2);
		}
		return result;
	}

}
