/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.provider.helper;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TableColumn;

/**
 * Einfacher Spaltenkopflistener für BitCtrlTableViewer, der die Sortierspalten
 * und die Sortierrichtung für die Tabelle festlegt.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 *
 */
public class BitCtrlSpaltenkopfListener implements SelectionListener {

	/**
	 * Die Spalte, an der wir hängen.
	 */
	private final TableColumn column;

	/**
	 * Der Viewer, in dem wir registriert sind.
	 */
	private final TableViewer viewer;

	/**
	 * Kosntruktor übernimmt nur Werte.
	 *
	 * @param column
	 *            Die Spalte, an der wir hängen.
	 * @param viewer
	 *            Der Viewer, in dem wir registriert sind.
	 */
	public BitCtrlSpaltenkopfListener(final TableColumn column, final TableViewer viewer) {
		this.column = column;
		this.viewer = viewer;
	}

	@Override
	public void widgetDefaultSelected(final SelectionEvent e) {
		widgetSelected(e);
	}

	@Override
	public void widgetSelected(final SelectionEvent e) {
		final TableColumn currentSortColumn = viewer.getTable().getSortColumn();
		final int currentSortDirection = viewer.getTable().getSortDirection();
		if (column.equals(currentSortColumn)) { // Nur toggeln
			final int newSortDirection = currentSortDirection == SWT.DOWN ? SWT.UP : SWT.DOWN;
			viewer.getTable().setSortDirection(newSortDirection);
		} else {
			viewer.getTable().setSortColumn(column);
			viewer.getTable().setSortDirection(SWT.DOWN);
		}
		viewer.refresh();
	}

}
