/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.provider.helper;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.buv.plugin.param.Zeichenketten;
import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.sys.funclib.debug.Debug;

/**
 * Realisiert den Mehrfachauswahl-Dialog gemäß TBuV-137-5, Abb 5-42.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 *
 */
public class MehrfachauswahlDialog extends MessageDialog {

	/**
	 * Der Text für die Titelzeile des Dialogs.
	 */
	private static final String MEHRFACHAUSWAHL_DIALOG_TITLE = "Mehrfachauswahl";

	/**
	 * Der Haupttext des Dialogs, übernommen aus Abb 5-42.
	 */
	private static final String MEHRFACHAUSWAHL_DIALOG_MESSAGE = "Sie haben mehrere Parameterobjekte ausgewählt.\n\nDadurch werden diesen bei der Eingabe eines neuen Wertes explizite Werte zugewiesen, die von darüberliegenden globalen Parametersätzen abweichen!\n\nBitte überprüfen Sie Ihr Vorgehen und informieren Sie sich ggf. in der Hilfe bzw. der Dokumentation über den Zweck globaler Parameter.";

	/**
	 * Die Beschriftungen für die Schaltflächen des Dialogs, übernommen aus Abb
	 * 5-42.
	 */
	private static final String[] MEHRFACHAUSWAHL_DIALOG_BUTTONLABELS = { "OK", "Abbrechen",
			Zeichenketten.PLUGIN_PARAM_BUTTON_HILFE };

	/**
	 * Index der Schaltfläche 'Hilfe' innerhalb der Buttonbar.
	 */
	private static final int BUTTON_INDEX_HILFE = 2;

	/**
	 * Logger für alle Mehrfachauswahl-Dialoge.
	 */
	private static final Debug DEBUG = Debug.getLogger();

	/**
	 * Liefert das globale Flag zum Ein- oder Ausschalten der Warndialoge.
	 *
	 * @return das Flag
	 */
	public static boolean isEnabled() {
		final String warnungBeiMehrfachauswahl = ParamPlugin.getDefault().getLokalenParameter(
				Zeichenketten.PLUGIN_PARAM_PROPERTY_WARNUNG_BEI_MEHRFACHAUSWAHL,
				Zeichenketten.PLUGIN_PARAM_PROPERTY_WARNUNG_BEI_MEHRFACHAUSWAHL_DEFAULT);
		return "ja".equalsIgnoreCase(warnungBeiMehrfachauswahl);
	}

	/**
	 * Die Hilfe-ID, welche vom Helpsystem zu öffnen ist, wenn der Nutzer auf Hilfe
	 * drückt. Kann null oder leer sein, dann passiert gar nichts.
	 */
	private final String hilfeId;

	/**
	 * Konstruktor bedient nur den Superkonstruktor mit lokalen Konstanten und merkt
	 * sich die anzuzeigende Hilfe-Id.
	 *
	 * @param parentShell
	 *            Elternshell oder null.
	 * @param hilfeId
	 *            Die Hilfe-ID, welche vom Helpsystem zu öffnen ist, wenn der Nutzer
	 *            auf Hilfe drückt. Kann null oder leer sein, dann passiert gar
	 *            nichts.
	 */
	public MehrfachauswahlDialog(final Shell parentShell, final String hilfeId) {
		super(parentShell, MEHRFACHAUSWAHL_DIALOG_TITLE, null, MEHRFACHAUSWAHL_DIALOG_MESSAGE, MessageDialog.WARNING,
				MEHRFACHAUSWAHL_DIALOG_BUTTONLABELS, 1);
		this.hilfeId = hilfeId;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.eclipse.jface.dialogs.MessageDialog#createButtonsForButtonBar(org
	 * .eclipse.swt.widgets.Composite)
	 */
	@Override
	protected void createButtonsForButtonBar(final Composite parent) {
		super.createButtonsForButtonBar(parent);
		if (null != hilfeId && hilfeId.length() > 0) {
			getButton(BUTTON_INDEX_HILFE).addSelectionListener(new SelectionAdapter() {

				@Override
				public void widgetSelected(final SelectionEvent e) {
					DEBUG.fine("Öffne Hilfe", hilfeId);
					PlatformUI.getWorkbench().getHelpSystem().displayHelp(hilfeId);
					close();
				}
			});
		}

	}

}
