/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.testprogramme;

import java.util.Collection;
import java.util.List;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.sys.funclib.application.StandardApplication;
import de.bsvrz.sys.funclib.application.StandardApplicationRunner;
import de.bsvrz.sys.funclib.bitctrl.modell.DefaultObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FahrStreifen;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnitt;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;

/**
 * Kleines Hilfsprogramm zum Finden aller MQ mit genau drei Fahrstreifen.
 *
 * Die Ausgaben dienen als Konfigurationshilfe
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 *
 */
public class NSpurigeMQFinder implements StandardApplication {

	/**
	 * Anzahl der Fahrspuren.
	 */
	private int numFahrspuren = 3;

	/**
	 * true - Namen verwenden, false - Pid verwenden.
	 */
	private boolean namen;

	@Override
	public void initialize(final ClientDavInterface connection) throws Exception {
		int count = 0;
		final ObjektFactory factory = DefaultObjektFactory.getInstanz();
		factory.setDav(connection);
		final List<? extends SystemObjekt> mqs = factory.bestimmeModellobjekte("typ.messQuerschnitt");
		System.out.println("Suche " + numFahrspuren + "-spurige MQ ...");
		for (final SystemObjekt o : mqs) {
			if (o instanceof MessQuerschnitt) {
				final MessQuerschnitt mq = (MessQuerschnitt) o;
				final Collection<FahrStreifen> alleFs = mq.getFahrStreifen();
				if (alleFs != null && alleFs.size() == numFahrspuren) {
					if (namen) {
						System.out.println(mq.getName());
					} else {
						System.out.print("<element pid=\"");
						System.out.print(mq.getPid());
						System.out.println("\"/>");
					}
					++count;
				}
			}
		}
		System.out.println("Fertig: " + count + " " + numFahrspuren + "-spurige MQ in " + mqs.size() + " MQs gefunden");
		System.exit(0);
	}

	@Override
	public void parseArguments(final ArgumentList argumentList) throws Exception {
		numFahrspuren = argumentList.fetchArgument("-numFahrspuren=3").intValue();
		namen = argumentList.fetchArgument("-namen=false").booleanValue();
	}

	/**
	 * Startpunkt.
	 *
	 * @param args
	 *            die Argumentliste enthält nur die allgemeinen DaV-App-Argumente
	 */
	public static void main(final String[] args) {
		StandardApplicationRunner.run(new NSpurigeMQFinder(), "typ.applikation", args);
	}
}
